---
source_url: https://cloud.google.com/products/gemini/pricing
source_type: llms-txt
content_hash: sha256:c03f71e17ed8c2768123a5ac3d5e9e3bf44e8cd6a99658c9a78999aa43ea3175
sitemap_url: https://geminicli.com/llms.txt
fetch_method: html
---

Gemini for Google Cloud pricing | Google Cloud

# Gemini for Google Cloud pricing

If you are looking for information about Gemini Code Assist for individuals, the free version of Gemini Code Assist, please visit [codeassist.google](https://codeassist.google/).

This page contains information about pricing for Gemini for Google Cloud. If you pay in a currency other than USD, then the prices listed in your currency on [Cloud Platform SKUs](https://cloud.google.com/skus) apply.

## Gemini Code Assist Standard and Enterprise Pricing Overview

[Gemini Code Assist](https://cloud.google.com/gemini/docs/codeassist/overview), which is available in Standard and Enterprise editions as part of Gemini for Google Cloud, is an AI-powered collaborator that helps your development team build, deploy, and operate applications throughout the software development life cycle (SDLC).

Gemini Code Assist:

* Helps development teams solve application code challenges and provide expert guidance directly in IDEs such as Visual Studio Code and IntelliJ IDEA.
* Lets operations teams get their jobs done faster and more effectively by working with an AI assistant that answers questions with Google Cloud curated answers.
* Provides expert-level insights on best practices.
* Accelerates your troubleshooting experience to help fix incidents quickly with code and conversational assistance.

Gemini Code Assist is available in two editions as part of Gemini for Google Cloud: Standard, Enterprise

| Feature | Standard | Enterprise |
| --- | --- | --- |
|  |  |  |
| --- | --- | --- |
| Code completion, code generation, chat in IDE | ✓ | ✓ |
| Local codebase awareness | ✓ | ✓ |
| Code transformation | ✓ | ✓ |
| Gemini in Colab Enterprise (Vertex AI) | ✓ | ✓ |
| Database Development Assistance | ✓ | ✓ |
| Gemini in Firebase | ✓ | ✓ |
| Enterprise-grade security and Gen AI indemnification | ✓ | ✓ |
| BigQuery Data insights | ✓ | ✓ |
| Automated Metadata Generation | ✓ | ✓ |
| Code Completion in Cloud Run | ✓ | ✓ |
| Agent mode | ✓ | ✓ |
| Gemini CLI | ✓ | ✓ |
| Code customization |  | ✓ |
| Gemini in Apigee |  | ✓ |
| Gemini in Application Integration |  | ✓ |
| Gemini Cloud Assist |  | ✓ |

Gemini in BigQuery Core features for building data driven experiences are available at no cost across all BigQuery compute options. See details in the Gemini in BigQuery section [below](https://cloud.google.com/products/gemini/pricing#gemini-in-bigquery-pricing).

### Standard edition

IDE focused AI-powered code assistant, with enterprise-grade security, helping developers accelerate software development.

* **Code completion, generation and chat**: Chat with Gemini to guide your application development and get code completion and generation for popular programming languages in your IDE
* **Local codebase awareness**: Leverage the power of Gemini's large context window for in-depth local codebase understanding
* **Code transformation**: Utilize smart actions and commands to quickly fix your code
* **Gemini in Colab Enterprise (Vertex AI)**: Accelerated code development in your Notebook with AI
* **Database Development Assistance**: Leverage AI assistance directly within your development workflow: use natural language to generate SQL, get schema-aware code generation, optimize query performance, and receive clear explanations of existing queries
* **Gemini in Firebase**: Help development teams build, launch, and scale their mobile and web apps with Firebase more rapidly
* **Enterprise-grade security and indemnification**: Robust data governance, secure infrastructure, and indemnification for code suggestions
* **BigQuery Data insights**: Insightful library of queries generated from the metadata of your tables
* **Code Completion in Cloud Run**: As you write functions in Cloud Run, Gemini can make code suggestions relevant to your current context. Code completion attempts to provide contextually appropriate recommendations that are based on content in the Cloud Run source editor
* **Agent mode**: A multi-step, collaborative, reasoning agent that expands the capabilities of simple command-response interactions inside Gemini Code Assist chat
* **Gemini CLI**: An open-source AI agent that brings the power of Gemini directly into your terminal

Subscriptions to Gemini Code Assist Standard are available with either a yearly or monthly commitment term. All subscriptions are billed monthly.

HourlyHourly

MonthlyMonthly

| Gemini license type | License fees (monthly commitment) | License fees (12-month commitment) |
| --- | --- | --- |
|  |  |  |
| --- | --- | --- |
| Gemini Code Assist Standard | $0.031232877 / 1 hour | $0.026027397 / 1 hour |

You can purchase your licenses directly from the [Gemini Admin console](https://cloud.google.com/gemini/docs/discover/set-up-gemini), or [connect with our sales team](https://inthecloud.withgoogle.com/enable-gemini-code-assist/cs-bsm.html) to get a custom quote for your organization.

### Enterprise edition

A comprehensive AI-powered application development solution with code assistance in the IDE and across Google Cloud services, with integrations into Enterprise knowledge bases, to accelerate application development across the tech stack.

With Gemini Code Assist Enterprise, you get all the benefits of Standard, plus:

* **Code customization**: Better quality, tailored responses based on your private code repositories
* **Gemini in Apigee**: Accelerate design, creation and operations of new and existing APIs
* **Gemini in Application Integration**: Supercharger your organizations process and automate the automation with AI
* **Additional Gemini Cloud Assist Features**: Gain access to advanced AI capabilities for infrastructure management, diagnostics, cost optimization, and more, as detailed in the Cloud Assist section below
* **Increased agent usage**: Do more with Gemini Code Assist agent mode and the Gemini CLI with increased [daily usage limits](https://cloud.google.com/gemini/docs/quotas)

Subscriptions to Gemini Code Assist Enterprise are available with either a yearly or monthly commitment term. All subscriptions are billed monthly.

HourlyHourly

MonthlyMonthly

| Gemini license type | License fees (monthly commitment) | License fees (12-month commitment) |
| --- | --- | --- |
|  |  |  |
| --- | --- | --- |
| Gemini Code Assist Enterprise | $0.073972603 / 1 hour | $0.061643836 / 1 hour |

###

## Gemini Cloud Assist Pricing Overview

Note: During the preview period, the features marked as 'Included in Code Assist Enterprise' are available at no additional charge.

[Gemini Cloud Assist](https://cloud.google.com/gemini/docs/cloud-assist/overview) is an AI-powered assistant integrated across Google Cloud, designed to help cloud teams design, operate, optimize, and troubleshoot their applications and infrastructure more effectively. It offers a range of features, some available for free and others included as part of the Gemini Code Assist Enterprise package.

|  | Feature | Available to All Google Cloud Users | Included in Code Assist Enterprise |
| --- | --- | --- | --- |
|  |  |  |  |
| --- | --- | --- | --- |
| Design & Build | Natural Language DesignPreview |  | ✓ |
|  | Infrastructure as CodePreview |  | ✓ |
| Diagnose & Resolve | InvestigationsPreview |  | ✓ |
|  | Support HandoffPreview |  | ✓ |
|  | Database Troubleshooting |  | ✓ |
| Optimize Cost/Usage | Cost optimization in FinOps HubPreview | ✓ | ✓ |
|  | Cost optimization in Cloud HubPreview | ✓ | ✓ |
|  | Database Optimization |  | ✓ |
| Google Cloud Assistance | Console ChatGA | ✓ | ✓ |
|  | Flow AnalyzerPreview | ✓ | ✓ |
|  | Cloud Observability | ✓ | ✓ |
|  | Storage InsightsPreview | ✓ | ✓ |
|  | IAM AssistancePreview | ✓ | ✓ |
| Firebase Assistance | Console ChatGA | ✓ | ✓ |
|  | GraphQL GenerationGA |  | ✓ |
|  | App Crash AnalysisGA |  | ✓ |
|  | Code AnalysisGA |  | ✓ |
|  | FCM Campaign AnalysisGA |  | ✓ |
|  | Troubleshooting AssistanceGA |  | ✓ |

## Gemini in BigQuery Pricing Overview

Core features around building data driven experiences are available to all editions at no additional cost. This includes SQL code assist, Python code assist, Data Canvas, and Data preparation.

|  |  | BigQuery Standard Edition | BigQuery Enterprise Edition | BigQuery Enterprise Plus Edition | BigQuery On-demand compute | Gemini Code Assist Standard |
| --- | --- | --- | --- | --- | --- | --- |
|  |  |  |  |  |  |  |
| --- | --- | --- | --- | --- | --- | --- |
| Core features for building data driven experiences | SQL code generationGA, explanationGA completionPreview | ✓ | ✓ | ✓ | ✓ | No purchase required |
|  | Python code generationGA, code completionGA | ✓ | ✓ | ✓ | ✓ | No purchase required |
|  | Data canvasGA | ✓ | ✓ | ✓ | ✓ | No purchase required |
|  | Data preparationGA | ✓ | ✓ | ✓ | ✓ | No purchase required |
| Advanced context | Data insightsGA |  | ✓\* | ✓\* | ✓\* | ✓ |
|  | Automated metadata generationGA |  | ✓\* | ✓\* | ✓\* | ✓ |

**\*** - Usage of this feature is based on org-level quota. Quota is earned based on usage of the compute edition usage where availability is marked as ✓. Users on BigQuery Enterprise or Enterprise Plus editions receive a dedicated quota for running insights scans as part of their subscription. Similarly, users with a Gemini Code Assist Standard license are also allocated a separate quota for insights usage. These quotas are consumed each time an insights scan is run. For a detailed description of quotas, see [Quotas for Gemini in BigQuery](https://cloud.google.com/gemini/docs/quotas#bigquery).
