# macOS Onboarding

Complete developer environment setup for macOS.

Follow these guides in order for the smoothest onboarding experience.

---

## Core Development Tools

### 1. Package Management

Install system-level package managers first - they make installing everything else easier.

- [Package Managers macOS](package-management/package-managers-macos.md)

### 2. Version Control

Set up Git before anything else - you'll need it for all development work.

> **Skills Available:** Git documentation has been consolidated into Claude Code skills for better maintainability. Invoke these skills directly:

- **git:setup** skill: Git installation and basic configuration (macOS-specific guidance)
- **git:line-endings** skill: Cross-platform line ending configuration
- **git:gui-tools** skill: Git GUI clients (GitKraken, Sourcetree, GitHub Desktop)
- **git:git-config** skill: Comprehensive configuration (aliases, performance tuning, credentials)
- **git:gpg-signing** skill: Commit signing setup and troubleshooting

### 3. Runtime Environments

Install language runtimes and version managers.

- [NVM Setup macOS](runtime-environments/nvm-setup-macos.md)

### 4. Shell & Terminal

Configure your command-line environment.

- [PowerShell Setup macOS](shell-terminal/powershell-setup-macos.md)
- [Shell Customization macOS](shell-terminal/shell-customization-macos.md) (optional)
- [Alternative Shells macOS](shell-terminal/alternative-shells-macos.md) (optional)

### 5. Code Editors

Install and configure your text editor or IDE.

- [Code Editors macOS](code-editors/code-editors-macos.md)

### 6. AI Tooling

AI-assisted development tools for enhanced productivity.

- [AI Tooling macOS](ai-tooling/ai-tooling-macos.md)

### 7. Containerization

Set up Docker for container-based development.

- [Docker Setup macOS](containerization/docker-setup-macos.md)

### 8. API Development

Tools for testing and debugging APIs.

- [API Tools macOS](api-development/api-tools-macos.md)

### 9. Web Browsers

Install browsers and developer tools for web development.

- [Browsers macOS](web-browsers/browsers-macos.md)

---

## Optional Enhancements

Install these as needed for your specific projects.

### Cloud Platforms

- [Azure CLI Setup macOS](cloud-platforms/azure-cli-setup-macos.md)

### Database Tools

- [Database Tools macOS](database-tools/database-tools-macos.md)

### Productivity

- [Productivity Tools macOS](productivity/productivity-tools-macos.md)
- [Figma Setup macOS](productivity/figma-setup-macos.md) (optional)

### Security

- [Security Tools macOS](security/security-tools-macos.md)

### System Tools

- [System Utilities macOS](system-tools/system-utilities-macos.md)
