---
source_url: https://developers.openai.com/codex/cloud
source_type: llms-txt
content_hash: sha256:455cbfddda5309212e53e174716a6565095ecd76b282cfc84def3b3e33514e4c
sitemap_url: https://developers.openai.com/codex/llms.txt
fetch_method: markdown
---

# Codex web

Codex is OpenAI's coding agent that can read, edit, and run code. It helps you build faster, fix bugs, and understand unfamiliar code. With Codex cloud, Codex can work on tasks in the background (including in parallel) using its own cloud environment.

## Codex web setup

Go to [Codex](https://chatgpt.com/codex) and connect your GitHub account. This lets Codex work with the code in your repositories and create pull requests from its work.

Your Plus, Pro, Business, Edu, or Enterprise plan includes Codex. Learn more about [what's included](https://developers.openai.com/codex/pricing). Some Enterprise workspaces may require [admin setup](https://developers.openai.com/codex/enterprise) before you can access Codex.

---

## Work with Codex web

<BentoContainer>
  <BentoContent href="/codex/prompting#prompts">

### Learn about prompting

Write clearer prompts, add constraints, and choose the right level of detail to get better results.

  </BentoContent>
  <BentoContent href="/codex/workflows">

### Common workflows

Start with proven patterns for delegating tasks, reviewing changes, and turning results into PRs.

  </BentoContent>
  <BentoContent href="/codex/cloud/environments">

### Configuring environments

Choose the repo, setup steps, and tools Codex should use when it runs tasks in the cloud.

  </BentoContent>
  <BentoContent href="/codex/ide/features#cloud-delegation">

### Delegate work from the IDE extension

Kick off a cloud task from your editor, then monitor progress and apply the resulting diffs locally.

  </BentoContent>
  <BentoContent href="/codex/integrations/github">

### Delegating from GitHub

Tag `@codex` on issues and pull requests to spin up tasks and propose changes directly from GitHub.

  </BentoContent>
  <BentoContent href="/codex/cloud/internet-access">

### Control internet access

Decide whether Codex can reach the public internet from cloud environments, and when to enable it.

  </BentoContent>
</BentoContainer>
