---
source_url: https://developers.openai.com/codex/exec-policy
source_type: llms-txt
content_hash: sha256:f3bbce92eb3c814ba472b4e64f1c233707fed8d5e58601c4c2881395101afa77
sitemap_url: https://developers.openai.com/codex/llms.txt
fetch_method: markdown
---

# Execution policy rules

Use execution policy rules to control which commands Codex can run outside the sandbox.

<DocsTip>Execution policy rules are experimental and may change.</DocsTip>

## Create a rules file

1. Create a `.rules` file under `~/.codex/rules` (for example, `~/.codex/rules/default.rules`).
2. Add a rule. This example prompts before allowing `gh pr view` to run outside the sandbox.

    ```python
    # Prompt before running commands with the prefix `gh pr view` outside the sandbox.
    prefix_rule(
        # The prefix to match.
        pattern = ["gh", "pr", "view"],

        # The action to take when Codex requests to run a matching command.
        decision = "prompt",

        # `match` and `not_match` are optional "inline unit tests" where you can
        # provide examples of commands that should (or should not) match this rule.
        match = [
            "gh pr view 7888",
            "gh pr view --repo openai/codex",
            "gh pr view 7888 --json title,body,comments",
        ],
        not_match = [
            # Does not match because the `pattern` must be an exact prefix.
            "gh pr --repo openai/codex view 7888",
        ],
    )
    ```

3. Restart Codex.

Codex loads every `*.rules` file under `~/.codex/rules` at startup. When you add a command to the allow list in the TUI, Codex appends a rule to `~/.codex/rules/default.rules` so future runs can skip the prompt.

## Understand rule fields

`prefix_rule()` supports these fields:

- `pattern` **(required)**: A non-empty list that defines the command prefix to match. Each element is either:
  - A literal string (for example, `"pr"`).
  - A union of literals (for example, `["view", "list"]`) to match alternatives at that argument position.
- `decision` **(defaults to `"allow"`)**: The action to take when the rule matches. Codex applies the most restrictive decision when more than one rule matches (`forbidden` > `prompt` > `allow`).
  - `allow`: Run the command outside the sandbox without prompting.
  - `prompt`: Prompt before each matching invocation.
  - `forbidden`: Block the request without prompting.
- `match` and `not_match` **(defaults to `[]`)**: Examples that Codex validates when it loads your rules. Use these to catch mistakes before a rule takes effect.

When Codex considers a command to run, it compares the command's argument list to `pattern`. Internally, Codex treats the command as a list of arguments (like what `execvp(3)` receives).

## Test a rule file

Use `codex execpolicy check` to test how your rules apply to a command:

```shell
codex execpolicy check --pretty \
  --rules ~/.codex/rules/default.rules \
  -- gh pr view 7888 --json title,body,comments
```

The command emits JSON showing the strictest decision and any matching rules. Use more than one `--rules` flag to combine files, and add `--pretty` to format the output.

## Understand the rules language

The `.rules` file format uses `Starlark` (see the [language spec](https://github.com/bazelbuild/starlark/blob/master/spec.md)). Its syntax is like Python, but it's designed to be safe to run: the rules engine can run it without side effects (for example, touching the filesystem).
