---
name: career-progression
description: Competency frameworks, level expectations (Junior to Staff+), and career progression paths for software engineers. Use when navigating promotions, understanding level requirements, or planning career advancement.
allowed-tools: Read, Glob, Grep
---

# Career Progression

This skill provides frameworks for understanding software engineering career levels, competency expectations, and progression paths from Junior to Staff+ engineer.

## Keywords

career levels, junior, mid-level, senior, staff, principal, promotion, competency, progression, IC track, management track, level expectations, career ladder, engineering levels, seniority

## When to Use This Skill

- Understanding expectations at each engineering level
- Planning progression to the next level
- Evaluating readiness for promotion
- Choosing between IC and management tracks
- Understanding competency frameworks
- Setting career development goals

## Engineering Levels Overview

Software engineering careers typically follow this progression:

| Level | Typical Titles | Experience | Scope of Impact |
| ----- | -------------- | ---------- | --------------- |
| L3 | Junior Engineer, SDE I | 0-2 years | Individual tasks |
| L4 | Engineer, SDE II | 2-5 years | Features, small projects |
| L5 | Senior Engineer | 5-8 years | Large projects, team impact |
| L6 | Staff Engineer | 8+ years | Multi-team, org-wide |
| L7+ | Principal, Distinguished | 10+ years | Company-wide, industry |

**Note:** Titles and levels vary by company. Focus on scope and expectations, not titles.

## Core Competency Categories

Engineering progression is measured across multiple dimensions, not just coding ability:

### 1. Technical/Implementation

- Code quality and best practices
- Debugging and problem-solving
- System understanding and mental models
- Performance optimization

### 2. Design

- Breaking down problems
- Architecture and system design
- Technical decision-making
- Risk assessment

### 3. Operations

- On-call and incident response
- Monitoring and observability
- Production ownership

### 4. Product

- Understanding business context
- Customer focus
- Requirements translation

### 5. Leadership

- Mentoring and teaching
- Influence without authority
- Process improvement
- Cross-team collaboration

### 6. Communication

- Written documentation
- Verbal articulation
- Stakeholder management
- Technical translation

## Level Expectations Summary

### Junior (L3) - Learning & Contributing

**Focus:** Building foundational skills under guidance

**Key Behaviors:**

- Complete well-defined tasks with mentorship
- Learn team's codebase and practices
- Ask questions and seek feedback
- Write clean, tested code
- Basic debugging and troubleshooting

**What "Good" Looks Like:**

- Delivers assigned work reliably
- Improves with feedback
- Contributes in code reviews
- Documents learnings

### Mid-Level (L4) - Independent Delivery

**Focus:** Owning features end-to-end with minimal guidance

**Key Behaviors:**

- Deliver complete features independently
- Mentor junior engineers informally
- Contribute to technical discussions
- Understand system architecture
- Balance pragmatism with quality

**What "Good" Looks Like:**

- Trusted to deliver without constant oversight
- Proactively identifies issues
- Helps teammates succeed
- Makes sound technical tradeoffs

### Senior (L5) - Technical Leadership

**Focus:** Leading projects and influencing team direction

**Key Behaviors:**

- Own large projects end-to-end
- Set technical direction for team
- Mentor multiple engineers
- Drive architecture decisions
- Bridge business and technical needs

**What "Good" Looks Like:**

- Others seek your technical opinion
- Projects succeed because of your leadership
- Team improves from your contributions
- Stakeholders trust your judgment

### Staff (L6) - Organizational Impact

**Focus:** Enabling others and driving cross-team initiatives

**Key Behaviors:**

- Less doing, more enabling
- Set technical direction across teams
- Design systems for scale and longevity
- Influence engineering culture
- Navigate organizational complexity

**What "Good" Looks Like:**

- Multiple teams benefit from your work
- You're consulted on critical decisions
- Systems you design are adopted broadly
- You shape how engineering is done

## Progression Timelines

Typical timelines (highly variable by individual and company):

| Transition | Typical Duration | Success Rate |
| ---------- | ---------------- | ------------ |
| Junior to Mid | 12-18 months | 85-90% |
| Mid to Senior | 18-24 months | 70-80% |
| Senior to Staff | 24-36+ months | 40-60% |
| Staff to Principal | Variable | 20-30% |

**Key Insight:** Timelines are guidelines, not guarantees. Focus on demonstrated impact, not time in role.

## IC vs Management Tracks

### Individual Contributor (IC) Track

**Characteristics:**

- Deep technical expertise
- Influence through technical leadership
- Design and architecture ownership
- Mentoring without direct reports

**Best For:**

- Love solving technical problems
- Want to stay hands-on with code
- Influence through expertise, not authority
- Enjoy teaching and mentoring

### Management Track

**Characteristics:**

- People leadership and development
- Process and team optimization
- Cross-functional coordination
- Career development responsibility

**Best For:**

- Energized by helping others grow
- Comfortable with ambiguity
- Enjoy organizational challenges
- Want direct impact on people

**Key Decision Factors:**

- What activities energize you vs drain you?
- Where do you add the most value?
- What does "success" look like to you?
- Can you try both before committing?

## Common Progression Blockers

### Technical Skills Alone Aren't Enough

Many engineers focus solely on coding, missing:

- Communication and documentation
- Cross-team collaboration
- Business context understanding
- Mentoring and knowledge sharing

### Visibility Gap

Doing great work isn't enough if:

- No one knows about your contributions
- You don't advocate for yourself
- Your manager can't articulate your impact

### Comfort Zone Trap

Staying in familiar territory prevents growth:

- Taking on only safe projects
- Avoiding stretch assignments
- Not seeking feedback
- Resisting new technologies/domains

### Soft Skills Neglect

Technical excellence without soft skills limits advancement:

- Poor communication creates friction
- Lack of empathy reduces influence
- Inability to persuade blocks leadership
- No mentoring delays team growth

## References

For detailed guidance, see:

- `references/level-expectations.md` - Detailed expectations by level with examples
- `references/competency-categories.md` - Deep dive into each competency area
- `references/progression-timelines.md` - Timeline guidance and success factors
- `references/ic-vs-management.md` - Track comparison and decision framework

## Related Skills

- `promotion-preparation` - Building your promotion case
- `career-strategy` - Internal vs external growth paths
- `interview-skills` - Demonstrating level in interviews

## Related Commands

- `/soft-skills:assess-readiness` - Evaluate your readiness for next level
- `/soft-skills:plan-career-goals` - Set structured career goals

## Version History

- **v1.0.0** (2025-12-26): Initial release

---

## Last Updated

**Date:** 2025-12-26
**Model:** claude-opus-4-5-20251101
