# Competency Categories Reference

Deep dive into each competency category used to evaluate engineering progression.

## 1. Technical/Implementation

The foundation of engineering excellence.

### Subcategories

**Code Quality:**

- Clean, readable, maintainable code
- Following team/company style guides
- Appropriate abstraction levels
- Error handling and edge cases

**Testing:**

- Unit test coverage
- Integration testing
- Test-driven development
- Testing strategy for features

**Debugging:**

- Systematic problem diagnosis
- Root cause analysis
- Using debugging tools effectively
- Post-mortem and learning

**Performance:**

- Writing efficient code
- Identifying bottlenecks
- Optimization techniques
- Resource management

**Security:**

- Secure coding practices
- Authentication/authorization understanding
- Vulnerability awareness
- Data protection

### Level Progression

| Level | Technical Expectation |
| ----- | --------------------- |
| Junior | Writes working code with guidance |
| Mid | Writes production-quality code independently |
| Senior | Sets technical standards, reviews architecture |
| Staff | Defines technical strategy, evaluates technologies |

---

## 2. Design

Turning problems into solutions.

### Subcategories

**Problem Decomposition:**

- Breaking down complex problems
- Identifying components and boundaries
- Sequencing work appropriately

**System Design:**

- Architecture patterns
- Scalability considerations
- Reliability and fault tolerance
- Data modeling

**Technical Decision-Making:**

- Evaluating trade-offs
- Build vs buy analysis
- Technology selection
- Risk assessment

**Documentation:**

- Design documents
- Architecture diagrams
- Decision records (ADRs)
- Technical specifications

### Level Progression

| Level | Design Expectation |
| ----- | ------------------ |
| Junior | Understands and follows designs |
| Mid | Creates designs for medium features |
| Senior | Leads design for large systems |
| Staff | Defines architecture for organization |

### Key Design Questions by Level

**Junior:**

- "What are the requirements?"
- "How should I implement this?"

**Mid:**

- "What are the trade-offs?"
- "How does this fit the system?"

**Senior:**

- "What's the right architecture?"
- "How do we scale this?"

**Staff:**

- "What's the technical vision?"
- "How does this serve the business?"

---

## 3. Operations

Keeping systems running reliably.

### Subcategories

**On-Call/Incident Response:**

- Following runbooks
- Triaging and escalating
- Incident command
- Post-incident reviews

**Monitoring/Observability:**

- Metrics and alerting
- Logging strategy
- Tracing and debugging
- Dashboard creation

**Reliability:**

- SLO/SLA understanding
- Error budgets
- Capacity planning
- Disaster recovery

**Deployment:**

- CI/CD practices
- Release management
- Rollback procedures
- Feature flags

### Level Progression

| Level | Operations Expectation |
| ----- | ---------------------- |
| Junior | Follows on-call procedures |
| Mid | Handles incidents, improves monitoring |
| Senior | Leads incident response, defines SLOs |
| Staff | Sets reliability strategy, leads major incidents |

---

## 4. Product

Understanding and serving customers.

### Subcategories

**Requirements:**

- Understanding user needs
- Translating business to technical
- Clarifying ambiguity
- Scoping and prioritization

**Customer Focus:**

- User experience awareness
- Impact measurement
- Feedback incorporation
- Quality mindset

**Business Context:**

- Understanding company goals
- Market awareness
- ROI considerations
- Strategic alignment

### Level Progression

| Level | Product Expectation |
| ----- | ------------------- |
| Junior | Implements requirements as given |
| Mid | Clarifies requirements, suggests improvements |
| Senior | Shapes product direction with PMs |
| Staff | Influences product strategy technically |

---

## 5. Leadership

Influencing and enabling others.

### Subcategories

**Mentoring:**

- Teaching and coaching
- Pair programming
- Code review as teaching
- Career guidance

**Influence:**

- Persuading without authority
- Building consensus
- Leading by example
- Driving change

**Project Leadership:**

- Planning and estimation
- Risk management
- Stakeholder coordination
- Delivery accountability

**Culture:**

- Modeling behaviors
- Process improvement
- Knowledge sharing
- Team building

### Level Progression

| Level | Leadership Expectation |
| ----- | ---------------------- |
| Junior | Open to guidance |
| Mid | Mentors informally, leads small efforts |
| Senior | Mentors actively, leads large projects |
| Staff | Develops senior engineers, shapes culture |

### Leadership Without Management

Staff+ engineers demonstrate leadership through:

- Technical influence and decision-making
- Mentoring and developing others
- Setting standards and best practices
- Driving initiatives without direct reports
- Building consensus across teams

---

## 6. Communication

Sharing information effectively.

### Subcategories

**Written:**

- Documentation quality
- Email and Slack clarity
- Design document writing
- RFC/proposal authoring

**Verbal:**

- Meeting effectiveness
- Presentation skills
- Technical explanations
- Stakeholder conversations

**Cross-Functional:**

- PM collaboration
- Design partnership
- Customer communication
- Leadership updates

### Level Progression

| Level | Communication Expectation |
| ----- | ------------------------- |
| Junior | Clear in team contexts |
| Mid | Effective across team and stakeholders |
| Senior | Influences through communication |
| Staff | Communicates vision, shapes understanding |

### Communication by Audience

| Audience | Focus |
| -------- | ----- |
| Engineers | Technical accuracy, depth |
| Product | Business context, trade-offs |
| Leadership | Impact, strategy, risks |
| Customers | Clarity, empathy, solutions |

---

## Using Competencies for Self-Assessment

### Evaluation Framework

For each competency:

1. **Current level:** Where am I now?
2. **Evidence:** What demonstrates this level?
3. **Next level:** What does the next level look like?
4. **Gap:** What's missing?
5. **Development:** How do I grow?

### Balanced Development

Avoid:

- Overinvesting in strongest area
- Ignoring critical weaknesses
- Focusing only on technical skills

Aim for:

- "T-shaped" skills (broad + deep)
- No critical gaps blocking progression
- Continuous improvement in all areas
