# Level Expectations Reference

Detailed expectations for each engineering level with concrete examples and observable behaviors.

## Junior Engineer (L3/SDE I)

### Core Expectations

**Technical:**

- Write clean, readable code following team standards
- Complete tasks within estimated timeframes (with buffer)
- Basic understanding of team's tech stack
- Effective use of debugging tools
- Write unit tests for your code

**Design:**

- Decompose tasks into smaller steps
- Understand requirements before coding
- Ask clarifying questions

**Operations:**

- Follow on-call procedures
- Escalate appropriately
- Update documentation

**Communication:**

- Ask for help when stuck (but try first)
- Participate in code reviews
- Update tickets and status

### Observable Behaviors

**Ready for Promotion When:**

- Completes features with minimal guidance
- Code reviews require fewer iterations
- Others start asking you questions
- Takes initiative on small improvements
- Mentors newer team members informally

**Example Accomplishments:**

- "Implemented user profile feature with 90% test coverage"
- "Reduced page load time by identifying inefficient query"
- "Created documentation for onboarding new team members"

---

## Mid-Level Engineer (L4/SDE II)

### Core Expectations

**Technical:**

- Own features end-to-end (design to deployment)
- Deep understanding of team's codebase
- Identify and address tech debt
- Performance-conscious development
- Strong debugging skills

**Design:**

- Contribute to technical discussions
- Evaluate trade-offs effectively
- Write design documents for medium features
- Consider edge cases and failure modes

**Operations:**

- Handle incidents independently
- Improve monitoring and alerting
- On-call without escalating everything

**Leadership:**

- Mentor junior engineers
- Lead small projects
- Drive process improvements

**Communication:**

- Clear written documentation
- Effective in meetings
- Stakeholder updates

### Observable Behaviors

**Ready for Promotion When:**

- Trusted to own significant features alone
- Sought out for technical advice
- Improves team processes/practices
- Successfully leads medium-sized projects
- Demonstrates cross-functional collaboration

**Example Accomplishments:**

- "Led migration to new payment provider, zero downtime"
- "Mentored 2 junior engineers, both promoted within year"
- "Designed and implemented caching layer, 60% latency reduction"
- "Created testing framework adopted by 3 teams"

---

## Senior Engineer (L5)

### Core Expectations

**Technical:**

- Expert in team's domain
- Architecture and system design
- Complex problem decomposition
- Performance optimization at scale
- Technical debt prioritization

**Design:**

- Lead design for large features
- Review others' designs
- Make sound architectural decisions
- Balance short-term and long-term needs

**Operations:**

- Incident command capability
- System reliability ownership
- Capacity planning

**Leadership:**

- Mentor multiple engineers
- Influence team direction
- Cross-team collaboration
- Project planning and execution

**Communication:**

- Translate technical concepts for stakeholders
- Write proposals and RFCs
- Drive consensus on technical decisions

### Observable Behaviors

**Ready for Promotion When:**

- Multiple teams seek your input
- Lead initiatives spanning multiple quarters
- Influence engineering practices broadly
- Develop other senior engineers
- Navigate organizational complexity

**Example Accomplishments:**

- "Architected microservices migration for payments domain"
- "Established code review standards adopted company-wide"
- "Led cross-team initiative reducing deploy time by 70%"
- "Mentored 3 engineers to senior level"

---

## Staff Engineer (L6)

### Core Expectations

**Technical:**

- Set technical direction for organization
- Design systems spanning multiple teams
- Evaluate and introduce new technologies
- Deep expertise in specialized areas

**Design:**

- Architect complex, multi-team systems
- Technical strategy and roadmaps
- Risk assessment and mitigation
- Build vs buy decisions

**Leadership:**

- Less execution, more enabling
- Raise the bar for engineering
- Influence without authority
- Develop senior engineers

**Organizational:**

- Navigate company politics productively
- Align technical work with business goals
- Build relationships across organization
- Represent engineering to leadership

### Observable Behaviors

**At Level:**

- Consulted on critical technical decisions
- Systems you design are adopted broadly
- Multiple teams benefit from your work
- You shape how engineering is done
- Senior+ engineers seek your mentorship

**Example Accomplishments:**

- "Designed company-wide observability platform"
- "Led technical due diligence for acquisition"
- "Established engineering career ladder"
- "Authored technical vision document adopted by org"

---

## Common Patterns by Level

### Scope of Ownership

| Level | Typical Scope |
| ----- | ------------- |
| Junior | Individual tasks |
| Mid | Features, small services |
| Senior | Large features, team systems |
| Staff | Multi-team systems, org initiatives |
| Principal | Company-wide, industry impact |

### Mentoring Evolution

| Level | Mentoring Style |
| ----- | --------------- |
| Junior | Receive mentoring |
| Mid | Informal peer mentoring |
| Senior | Active mentoring of juniors/mids |
| Staff | Develop senior engineers |
| Principal | Shape engineering culture |

### Decision-Making

| Level | Decision Authority |
| ----- | ------------------ |
| Junior | Implementation details |
| Mid | Feature implementation |
| Senior | Project architecture |
| Staff | Team/org technical direction |
| Principal | Company technical strategy |
