# Progression Timelines Reference

Understanding typical timelines, success factors, and what affects progression speed.

## Typical Timelines

### Industry Averages

| Transition | Typical Range | Median |
| ---------- | ------------- | ------ |
| Junior to Mid | 12-24 months | 18 months |
| Mid to Senior | 18-36 months | 24 months |
| Senior to Staff | 24-60 months | 36 months |
| Staff to Principal | 36-84 months | Variable |

**Important:** These are guidelines, not rules. Individual timelines vary significantly.

### Success Rates

| Transition | Success Rate | Notes |
| ---------- | ------------ | ----- |
| Junior to Mid | 85-90% | Most make it eventually |
| Mid to Senior | 70-80% | Common career plateau |
| Senior to Staff | 40-60% | Significant narrowing |
| Staff to Principal | 20-30% | Few positions available |

### Factors That Accelerate Progression

**High Impact Work:**

- Projects with measurable business impact
- Solving critical problems
- Working on high-visibility initiatives

**Strong Mentorship:**

- Manager who advocates for you
- Senior+ engineers who guide you
- Active feedback and coaching

**Growth Opportunities:**

- Stretch assignments
- Cross-team projects
- New technology adoption
- Leadership opportunities

**Company Context:**

- Fast-growing companies promote faster
- New teams need senior talent
- Re-orgs create opportunities

### Factors That Slow Progression

**Limited Visibility:**

- Great work no one knows about
- Manager can't articulate your impact
- Not advocating for yourself

**Comfort Zone:**

- Same type of work repeatedly
- Avoiding challenging projects
- Not seeking feedback

**Skill Gaps:**

- Ignoring soft skills
- Technical debt in key areas
- Communication challenges

**Company Context:**

- Slow-growing companies
- Limited positions at next level
- Organizational politics

---

## Timeline Expectations by Level

### Junior to Mid (12-24 months)

**What Typically Happens:**

- First 6 months: Learning, asking questions, contributing
- Months 6-12: Increasing independence, owning features
- Months 12-18: Mentoring newer members, leading small projects
- Months 18-24: Ready for promotion if demonstrating consistency

**Green Flags:**

- Completing features with decreasing guidance
- Others ask you questions
- Taking initiative on improvements
- Positive feedback from team

**Red Flags:**

- Still needing significant guidance
- Same mistakes repeated
- Not growing scope of work
- Feedback not improving

### Mid to Senior (18-36 months)

**What Typically Happens:**

- Months 0-6: Establishing independence, owning systems
- Months 6-18: Leading projects, mentoring, cross-team work
- Months 18-24: Technical leadership, architecture contributions
- Months 24-36: Ready for promotion with demonstrated leadership

**Green Flags:**

- Sought out for technical advice
- Successfully leading projects
- Improving team practices
- Cross-functional collaboration

**Red Flags:**

- Only executing, not leading
- Avoiding stretch assignments
- Not mentoring others
- Limited scope expansion

### Senior to Staff (24-60 months)

**What Typically Happens:**

- This transition is fundamentally different
- Requires shift from "doing" to "enabling"
- Often involves creating your own opportunities
- May require patience and persistence

**Green Flags:**

- Multiple teams benefit from your work
- Consulted on critical decisions
- Influence beyond your team
- Developing other senior engineers

**Red Flags:**

- Still doing vs enabling
- Impact limited to your team
- Not navigating organizational complexity
- Waiting for opportunities vs creating them

---

## Non-Linear Progression

### It's Normal to Plateau

Many engineers spend significant time at certain levels:

- Mid-level: Common plateau, perfectly fine career
- Senior: Many stay here for entire career
- Staff: Not everyone reaches this level

**Plateaus aren't failures.** They're natural points where:

- Skills consolidate
- Depth increases without level change
- Lateral growth happens

### Moving Between Tracks

Common transitions:

- IC to Management (and back)
- Generalist to Specialist
- Product Engineering to Infrastructure
- Company switches resetting level

Each transition may affect timeline.

### Company-Specific Factors

**Startup vs Big Tech:**

- Startups: Faster progression, less defined levels
- Big Tech: Structured process, more positions

**Company Stage:**

- Early stage: Rapid progression possible
- Mature: More competition, slower

**Industry:**

- High-growth sectors: More opportunities
- Traditional industries: Slower progression

---

## Making the Most of Your Timeline

### Quarterly Review

Every quarter, assess:

1. What did I accomplish?
2. What did I learn?
3. What skills did I develop?
4. What impact did I have?
5. Am I on track for my goals?

### Annual Planning

Yearly, evaluate:

1. Where am I vs where I want to be?
2. What's the gap to next level?
3. What opportunities exist?
4. What do I need to develop?
5. Is my current situation enabling growth?

### Promotion Timing

Best times to push for promotion:

- After completing major project
- When taking on next-level work
- During review cycles
- When manager is supportive
- When position is available

Challenging times:

- During company turmoil
- Before demonstrating impact
- When manager isn't aligned
- When there's no position
