---
name: career-strategy
description: Internal vs external career growth paths, goal setting, career maintenance, and long-term planning for software engineers. Use when deciding between internal promotion vs external job search, setting career goals, or planning long-term career trajectory.
allowed-tools: Read, Glob, Grep
---

# Career Strategy

Strategic career planning for software engineers, including internal vs external growth paths, goal setting, career maintenance practices, and long-term career trajectory planning.

## When to Use This Skill

- Deciding between pursuing internal promotion vs external opportunities
- Setting career goals and creating development plans
- Planning long-term career trajectory
- Assessing readiness for external job market
- Building and maintaining professional network
- Creating career maintenance habits

## The Strategic Career Framework

### Career Growth Paths

Software engineers have two primary growth paths:

1. **Internal Growth**: Advancement within your current organization
2. **External Growth**: Advancement by changing companies

Both paths have trade-offs, and the best choice depends on your circumstances, goals, and current position.

### The Career Maintenance Mindset

Career management isn't just for job searches. Consistent maintenance habits create:

- Ready-to-use resume at any time
- Strong professional network before you need it
- Clear understanding of your market value
- Options when opportunities arise
- Resilience against unexpected changes

## Internal vs External Decision Framework

### When Internal Growth Typically Works Better

**Organizational factors:**

- Clear promotion path exists
- Company is growing (creates opportunities)
- Your work is visible to decision-makers
- Manager actively supports your growth
- Compensation is competitive

**Personal factors:**

- You enjoy the team and culture
- You're learning and growing
- You have strong internal reputation
- You value stability and known environment
- You're building toward a specific internal opportunity

### When External Growth Typically Works Better

**Organizational factors:**

- Promotion path blocked or unclear
- Company is stagnant or declining
- Your contributions aren't recognized
- Compensation significantly below market
- Limited learning opportunities

**Personal factors:**

- You've plateaued in learning
- You want exposure to different problems
- You need a compensation reset
- You want a title/level not achievable internally
- You want to work with different technologies

### The Hybrid Approach

Many successful engineers use both:

1. **Primary focus**: Internal growth and value delivery
2. **Background activity**: Market awareness and network maintenance
3. **Trigger events**: Reassess when major changes occur

## Goal Setting Framework

### Effective Career Goals

Goals should be:

- **Specific**: Clear outcome, not vague aspiration
- **Measurable**: You know when you've achieved it
- **Achievable**: Realistic given your starting point
- **Relevant**: Aligned with long-term career vision
- **Time-bound**: Has a target date

### Goal Categories

**Technical growth:**

- Master a new technology or domain
- Lead technical design for a major system
- Contribute to open source
- Earn relevant certifications

**Leadership growth:**

- Mentor junior engineers
- Lead a project or team
- Present at a conference
- Establish yourself as domain expert

**Career advancement:**

- Get promoted to next level
- Transition to a new specialty
- Increase compensation by X%
- Land role at target company

**Personal development:**

- Improve communication skills
- Build executive presence
- Expand professional network
- Achieve work-life balance goals

### Goal-Setting Process

1. **Envision**: Where do you want to be in 2-5 years?
2. **Assess**: What gaps exist between current and desired state?
3. **Prioritize**: Which gaps are most important to close?
4. **Plan**: What specific actions will close each gap?
5. **Execute**: Take consistent action
6. **Review**: Regularly assess progress and adjust

## Career Maintenance Practices

### Weekly Habits (15-30 minutes)

- Update brag document with wins
- Engage with professional network (LinkedIn, Twitter/X)
- Read 1-2 industry articles or blog posts
- Reflect on week's learnings

### Monthly Habits (1-2 hours)

- Review and update skills inventory
- Have at least one networking conversation
- Read or watch one in-depth technical resource
- Review progress toward career goals

### Quarterly Habits (2-4 hours)

- Update resume with recent accomplishments
- Review and adjust career goals
- Research market conditions and compensation
- Identify and connect with new contacts

### Annual Habits (4-8 hours)

- Comprehensive resume update and review
- Full career assessment and planning
- Compensation market research
- Network audit and relationship nurturing

## Building and Maintaining Your Network

### Network Categories

**Inner circle (5-10 people):**

- Close mentors and sponsors
- Former colleagues who know you well
- People who will advocate for you
- Regular, meaningful contact

**Active network (50-100 people):**

- Current and recent colleagues
- Industry peers at similar level
- People you've helped or who've helped you
- Regular but less frequent contact

**Extended network (hundreds):**

- LinkedIn connections
- Conference contacts
- Alumni networks
- Passive, occasional contact

### Networking Best Practices

**Give before asking:**

- Share useful content
- Make introductions
- Offer help without expectation

**Stay in touch proactively:**

- Comment on updates
- Send relevant articles
- Congratulate on achievements

**Build relationships, not transactions:**

- Show genuine interest
- Follow up after conversations
- Remember personal details

## References

For detailed guidance on specific topics:

- [Internal vs External Comparison](references/internal-external-comparison.md) - Decision framework and trade-offs
- [Goal Setting Framework](references/goal-setting-framework.md) - SMART goals for career advancement
- [Career Maintenance Checklist](references/career-maintenance-checklist.md) - Regular activities for career health
- [External Readiness Assessment](references/external-readiness.md) - Assessing job market preparedness

## Related Resources

- `career-progression` skill - Level expectations and competency frameworks
- `promotion-preparation` skill - Brag documents and promotion cases
- `resume-optimization` skill - Resume tailoring and ATS optimization
- `career-coach` agent - Interactive career guidance
- `/soft-skills:plan-career-goals` command - Create structured career goals
- `/soft-skills:assess-readiness` command - Self-assessment for career moves

## Version History

- v1.0.0 (2025-12-23): Initial release with career strategy framework
