# Career Maintenance Checklist

Regular activities and habits for maintaining career health, regardless of whether you're actively job searching.

## The Case for Career Maintenance

**Why maintain when not job searching?**

- Ready for unexpected opportunities
- Prepared for unexpected setbacks
- Clear understanding of market value
- Strong network when needed
- Less stressful than frantic job searching
- Better negotiating position (can walk away)

**The compounding effect:**

- Weekly brag doc updates = comprehensive promotion case
- Regular networking = help when needed
- Continuous learning = relevant skills
- Updated resume = quick applications

## Weekly Habits (15-30 minutes)

### Brag Document Update

**Every Friday, capture:**

- Wins and accomplishments from the week
- Problems solved
- Impact delivered
- Positive feedback received
- Skills demonstrated or learned

**Template:**

```markdown
## Week of [Date]

### Wins
- [Accomplishment with brief context]

### Impact
- [Measurable result or outcome]

### Feedback
- [Any recognition or positive comments]

### Learning
- [New skill or knowledge gained]
```

### Professional Network Engagement

**15 minutes of engagement:**

- Comment on 2-3 LinkedIn posts
- Share one relevant article
- React to updates from connections
- Post brief update if you have something to share

**Quality over quantity:**

- Thoughtful comments beat mass reactions
- Share content you genuinely find valuable
- Engage with people you want to know better

### Industry Awareness

**Stay informed:**

- Scan 1-2 industry newsletters
- Read 1 technical blog post
- Note any significant industry news
- Track trends relevant to your role

**Recommended sources:**

- Hacker News (curated tech news)
- Company engineering blogs
- Technology-specific newsletters
- Professional community discussions

## Monthly Habits (1-2 hours)

### Skills Inventory Update

**Monthly review:**

- New skills acquired this month
- Skills deepened through practice
- Skills that need refreshing
- Skills to prioritize next month

**Track by category:**

- Languages and frameworks
- Tools and platforms
- Soft skills
- Domain knowledge

### Networking Conversation

**At least one meaningful conversation:**

- Coffee chat with colleague from another team
- Virtual call with former colleague
- Industry peer connection
- Mentor or mentee meeting

**Quality conversation elements:**

- Learn about their current work
- Share relevant information or introductions
- Offer to help with something
- Follow up with anything promised

### Deep Learning

**One substantial learning activity:**

- Complete a course module
- Read a technical book chapter
- Work through a tutorial
- Attend a webinar or conference talk

**Document what you learn:**

- Key takeaways
- How it applies to your work
- Questions to explore further

### Goal Progress Review

**Monthly check-in:**

- Progress toward annual goals
- Actions taken this month
- Adjustments needed
- Focus for next month

## Quarterly Habits (2-4 hours)

### Resume Update

**Every quarter, update:**

- Recent accomplishments (with metrics)
- New skills acquired
- Projects completed
- Title or scope changes

**Even if not job searching:**

- Easier to remember recent work
- Ready for unexpected opportunities
- Good prompt for self-reflection
- Ensures nothing is forgotten

### Career Goal Review

**Quarterly assessment:**

- Progress toward annual goals
- Goals still relevant?
- New opportunities emerged?
- Adjustments needed?

**Recalibration points:**

- After major project completion
- After performance review
- After significant company changes
- When interests shift

### Market Research

**Understand your market value:**

- Check job postings at your level
- Note compensation ranges
- Identify in-demand skills
- Track hiring trends

**Sources:**

- LinkedIn job postings
- Levels.fyi for compensation
- Glassdoor for trends
- Industry surveys

### Network Audit

**Review your network:**

- Who have you lost touch with?
- Who should you know better?
- Who can you help?
- Who could be helpful to know?

**Action items:**

- Reach out to 3 dormant connections
- Identify 2 new people to connect with
- Plan 1 networking event to attend

## Annual Habits (4-8 hours)

### Comprehensive Resume Overhaul

**Full resume review:**

- Update all roles and accomplishments
- Refresh summary/objective
- Update skills section completely
- Ensure consistent formatting
- Get external review

**Quality checks:**

- Spelling and grammar
- Consistent tense
- Quantified achievements
- ATS-friendly formatting

### Career Assessment

**Annual deep reflection:**

**Satisfaction assessment:**

- What do you enjoy about your work?
- What drains your energy?
- Are you learning and growing?
- Is your impact meaningful?

**Progress assessment:**

- Where were you a year ago?
- What did you accomplish?
- How did you grow?
- What didn't go as planned?

**Future planning:**

- Where do you want to be next year?
- What needs to change?
- What goals should you set?
- What support do you need?

### Compensation Research

**Annual market check:**

- Research current market rates
- Compare to your compensation
- Identify any significant gaps
- Prepare for compensation discussions

**Gather data from:**

- Levels.fyi
- Glassdoor
- Industry surveys
- Network conversations (carefully)

### Network Nurturing

**Annual relationship maintenance:**

- Review important connections
- Send updates to key contacts
- Arrange catch-ups with important people
- Clean up inactive connections

**Annual outreach targets:**

- Former managers (1-2)
- Important former colleagues (3-5)
- Industry mentors (1-2)
- Professional friends (5-10)

### Professional Development Plan

**Plan learning for next year:**

- What skills to develop?
- What certifications to pursue?
- What experiences to seek?
- What resources needed?

**Budget allocation:**

- Learning budget from employer
- Personal investment
- Time allocation
- Priority ranking

## Trigger-Based Activities

### After Major Accomplishment

**Immediately:**

- Add to brag document with full details
- Draft resume bullet while fresh
- Note metrics and outcomes
- Identify who to thank/acknowledge

**Within a week:**

- Share update with network (if appropriate)
- Request feedback or recommendations
- Update LinkedIn if significant
- Tell your manager (ensure visibility)

### After Receiving Feedback

**Process feedback:**

- Add positive feedback to brag document
- Reflect on constructive feedback
- Identify action items
- Follow up on any commitments

### After Industry News

**Stay informed:**

- Assess impact on your career
- Identify opportunities or threats
- Update skills priorities if needed
- Discuss with network

### After Company Changes

**Reassess:**

- Impact on your role and growth
- Changes to opportunities
- Whether goals need adjustment
- Whether to explore external options

## Master Checklist

### Weekly (Every Friday)

- [ ] Update brag document
- [ ] 15 minutes LinkedIn engagement
- [ ] Scan industry news
- [ ] Note anything to follow up on

### Monthly (First weekend of month)

- [ ] Review and update skills inventory
- [ ] Have one networking conversation
- [ ] Complete one learning activity
- [ ] Review goal progress

### Quarterly (Start of quarter)

- [ ] Update resume with recent work
- [ ] Review and adjust career goals
- [ ] Research market conditions
- [ ] Audit and nurture network

### Annually (Year-end or birthday)

- [ ] Comprehensive resume overhaul
- [ ] Full career assessment
- [ ] Compensation market research
- [ ] Network relationship nurturing
- [ ] Professional development planning

## Building the Habit

### Starting Small

**Week 1-4:** Just brag document updates
**Month 2-3:** Add weekly networking engagement
**Month 4-6:** Add monthly habits
**After 6 months:** Full system running

### Habit Stacking

Link career maintenance to existing habits:

- "After my Friday standup, I update my brag doc"
- "First Saturday of the month, I review my goals"
- "When I finish my coffee Monday, I check industry news"

### Calendar Blocking

Schedule career maintenance:

- 15-minute weekly block for brag doc
- 1-hour monthly block for deeper review
- Half-day quarterly for comprehensive review
- Full day annually for assessment

### Accountability

Consider:

- Career accountability partner
- Mastermind group
- Mentor check-ins
- Manager 1:1 integration
