# External Readiness Assessment

Evaluate your preparedness for the external job market and identify gaps to address before actively searching.

## Readiness Dimensions

### 1. Resume Readiness

**Assessment checklist:**

| Item | Status | Notes |
| ---- | ------ | ----- |
| Resume updated in last 3 months | ☐ | |
| Recent accomplishments included | ☐ | |
| Metrics and quantification present | ☐ | |
| Skills section current | ☐ | |
| ATS-friendly formatting | ☐ | |
| Tailored version for target roles | ☐ | |
| Proofread and error-free | ☐ | |
| PDF and DOCX versions ready | ☐ | |

**Scoring:**

- 7-8 items: Resume ready
- 5-6 items: Minor updates needed
- <5 items: Significant work needed

### 2. Online Presence Readiness

**LinkedIn assessment:**

| Item | Status | Notes |
| ---- | ------ | ----- |
| Profile photo professional | ☐ | |
| Headline optimized for target role | ☐ | |
| Summary compelling and current | ☐ | |
| Experience section detailed | ☐ | |
| Skills endorsed and relevant | ☐ | |
| Recommendations present (3+) | ☐ | |
| Activity in last 30 days | ☐ | |
| Open to opportunities enabled | ☐ | |

**GitHub/Portfolio assessment:**

| Item | Status | Notes |
| ---- | ------ | ----- |
| Profile README present | ☐ | |
| Pinned repos showcase best work | ☐ | |
| Contribution activity visible | ☐ | |
| Projects documented clearly | ☐ | |
| Contact information available | ☐ | |

### 3. Interview Readiness

**Technical preparation:**

| Item | Status | Notes |
| ---- | ------ | ----- |
| Data structures and algorithms | ☐ | |
| System design concepts | ☐ | |
| Coding in primary language | ☐ | |
| Domain-specific knowledge | ☐ | |
| Recent practice (last 30 days) | ☐ | |

**Behavioral preparation:**

| Item | Status | Notes |
| ---- | ------ | ----- |
| Story bank with 8+ stories | ☐ | |
| STAR format comfortable | ☐ | |
| Leadership stories ready | ☐ | |
| Conflict resolution story | ☐ | |
| Failure/learning story | ☐ | |
| "Tell me about yourself" polished | ☐ | |
| Questions for interviewers ready | ☐ | |

### 4. Network Readiness

**Assessment:**

| Item | Status | Notes |
| ---- | ------ | ----- |
| 3+ people who can refer you | ☐ | |
| Recent contact with key connections | ☐ | |
| Target companies with connections | ☐ | |
| Recruiters in your network | ☐ | |
| Former colleagues reachable | ☐ | |
| Industry community involvement | ☐ | |

### 5. Market Knowledge

**Assessment:**

| Item | Status | Notes |
| ---- | ------ | ----- |
| Know current salary ranges | ☐ | |
| Understand market demand | ☐ | |
| Aware of hiring trends | ☐ | |
| Target companies identified | ☐ | |
| Role requirements understood | ☐ | |
| Interview process knowledge | ☐ | |

### 6. Financial Readiness

**Assessment:**

| Item | Status | Notes |
| ---- | ------ | ----- |
| Emergency fund (3-6 months) | ☐ | |
| Know minimum acceptable salary | ☐ | |
| Understand total compensation | ☐ | |
| Current equity/bonus timing | ☐ | |
| Healthcare coverage plan | ☐ | |
| Financial runway calculated | ☐ | |

### 7. Practical Readiness

**Assessment:**

| Item | Status | Notes |
| ---- | ------ | ----- |
| References identified (3+) | ☐ | |
| References informed | ☐ | |
| Work samples available | ☐ | |
| Interview wardrobe ready | ☐ | |
| Interview space set up (virtual) | ☐ | |
| Schedule flexibility understood | ☐ | |

## Readiness Scoring

### Calculate Your Score

**For each dimension, rate 1-5:**

1. Not ready - major gaps
2. Partially ready - significant work needed
3. Moderately ready - some gaps to address
4. Mostly ready - minor improvements
5. Fully ready - prepared to start

| Dimension | Score (1-5) |
| --------- | ----------- |
| Resume | |
| Online Presence | |
| Interview Skills | |
| Network | |
| Market Knowledge | |
| Financial | |
| Practical | |
| **Total** | /35 |

### Interpretation

**30-35:** Ready to actively search

- Start applications
- Maintain momentum
- Focus on opportunities

**24-29:** Almost ready

- Address specific gaps
- 2-4 weeks of preparation
- Can start passive searching

**17-23:** Preparation needed

- Significant gaps to address
- 1-2 months of preparation
- Focus on weakest areas

**<17:** Not ready

- Major preparation required
- 2-3+ months of work
- Don't rush into searching

## Gap Remediation

### Resume Gaps

**If resume needs work:**

1. **Immediate (1-2 days):**
   - Update with recent role/accomplishments
   - Fix formatting issues
   - Proofread thoroughly

2. **Short-term (1 week):**
   - Add quantified achievements
   - Tailor for target roles
   - Get external review

3. **Ongoing:**
   - Create role-specific versions
   - A/B test different formats
   - Update after each milestone

### Interview Skill Gaps

**If interview skills need work:**

1. **Technical (2-4 weeks):**
   - Daily LeetCode/HackerRank practice
   - System design study
   - Mock technical interviews

2. **Behavioral (1-2 weeks):**
   - Build story bank
   - Practice STAR format
   - Mock behavioral interviews

3. **Company-specific:**
   - Research company interview process
   - Connect with people who've interviewed there
   - Practice company-specific formats

### Network Gaps

**If network needs strengthening:**

1. **Immediate:**
   - Update LinkedIn profile
   - Reach out to 5 dormant connections
   - Join relevant communities

2. **Short-term (2-4 weeks):**
   - Attend networking events
   - Request informational interviews
   - Reconnect with former colleagues

3. **Ongoing:**
   - Weekly engagement
   - Monthly meaningful conversations
   - Build relationships before asking for help

### Knowledge Gaps

**If market knowledge lacking:**

1. **Research (1-2 hours):**
   - Review job postings
   - Check salary databases
   - Read industry news

2. **Conversations (1-2 weeks):**
   - Talk to recruiters
   - Informational interviews
   - Network conversations

3. **Experience:**
   - Take recruiter calls
   - Do exploratory interviews
   - Attend company info sessions

## Timeline Planning

### Ideal Preparation Timeline

**6 months before desired start:**

- Assess readiness gaps
- Begin addressing major gaps
- Start building network
- Research target companies

**3 months before:**

- Resume polished and ready
- Interview skills sharp
- Network engaged
- Market knowledge current

**1 month before:**

- Ready to apply actively
- References lined up
- Calendar cleared for interviews
- Mentally prepared

**Active search:**

- Apply strategically
- Interview prepared
- Negotiate confidently
- Evaluate offers thoughtfully

### Compressed Timeline (If Needed)

**If you need to move quickly:**

Week 1:

- Resume intensive update
- LinkedIn optimization
- Begin interview prep

Week 2:

- Network activation
- Start applying
- Continue interview prep

Week 3-4:

- Active interviewing
- Continued preparation
- Network support

**Caution:** Compressed timelines mean:

- Less negotiating leverage
- Possible suboptimal outcomes
- Higher stress
- May need to accept good-enough

## Readiness Signals

### Signs You're Ready

- Confident discussing your accomplishments
- Clear about what you want next
- Know your minimum requirements
- Network is responsive
- Resume generates interest
- Can pass technical screens
- Comfortable with negotiation
- Financially stable

### Signs You're Not Ready

- Unsure what role you want
- Resume hasn't been updated
- No recent interview practice
- Network is dormant
- Don't know market rates
- Financially stressed
- Running from current job (not toward next)
- Unprepared for common questions

### Red Flags to Address First

**Before searching, resolve:**

- Employment gaps you can't explain
- Skills significantly outdated
- No quantifiable accomplishments
- Zero professional references
- Desperation or negative mindset
- Unclear value proposition

## Final Readiness Checklist

### Before Starting Applications

- [ ] Resume updated and polished
- [ ] LinkedIn profile optimized
- [ ] Story bank prepared (8+ stories)
- [ ] Technical skills practiced
- [ ] 3+ references identified and informed
- [ ] Target company list created
- [ ] Salary expectations researched
- [ ] Interview space ready
- [ ] Calendar has flexibility
- [ ] Support system in place

### Before Each Interview

- [ ] Company thoroughly researched
- [ ] Role requirements understood
- [ ] Relevant stories selected
- [ ] Questions for interviewer ready
- [ ] Technical prep appropriate for role
- [ ] Logistics confirmed
- [ ] Materials prepared (resume, portfolio)
- [ ] Mindset positive and confident

### Before Accepting Offer

- [ ] Compensation researched and negotiated
- [ ] Role and expectations clear
- [ ] Team and manager evaluated
- [ ] Growth path understood
- [ ] Start date workable
- [ ] Current job exit planned
- [ ] Counteroffer scenario prepared
- [ ] Decision not rushed
