---
name: developer-visibility
description: Build professional visibility through LinkedIn, GitHub, conference speaking, and internal branding. Provides frameworks for personal brand development, content creation, and career growth.
allowed-tools: Read, Glob, Grep, WebFetch, WebSearch
---

# Developer Visibility Skill

Build and maintain professional visibility as a software developer through strategic personal branding, content creation, and community engagement.

## Keywords

linkedin, github, portfolio, personal brand, branding, conference, speaking, cfp, call for papers, meetup, visibility, networking, thought leadership, content, blog, newsletter, internal visibility, career growth

## When to Use This Skill

This skill provides guidance when developers want to:

- Build their professional brand and online presence
- Create LinkedIn content that drives engagement
- Write conference proposals (CFPs) that get accepted
- Develop their personal brand statement
- Increase visibility within their organization
- Build credibility on GitHub and Stack Overflow
- Navigate self-promotion without feeling "salesy"

## Core Framework: Skills x Interests x Market Needs

Your personal brand niche lives at the intersection of three circles:

```text
        ┌─────────────┐
        │   SKILLS    │
        │ What am I   │
        │  good at?   │
        └──────┬──────┘
               │
    ┌──────────┼──────────┐
    │          │          │
    ▼          ▼          ▼
┌───────┐  ┌───────┐  ┌───────┐
│       │  │ YOUR  │  │       │
│       │◄─┤ NICHE ├─►│       │
│       │  │       │  │       │
└───┬───┘  └───────┘  └───┬───┘
    │                     │
    ▼                     ▼
┌─────────────┐   ┌─────────────┐
│  INTERESTS  │   │   MARKET    │
│ What do I   │   │   NEEDS     │
│   enjoy?    │   │ What's in   │
└─────────────┘   │   demand?   │
                  └─────────────┘
```

### Niche Discovery Exercise

Create three columns and list at least 5 items in each:

| Skills (What I'm good at) | Interests (What I enjoy) | Market Needs (What's in demand) |
| --- | --- | --- |
| Cloud architecture | Teaching/mentoring | AI/ML implementation |
| Performance optimization | Writing | Platform engineering |
| API design | Public speaking | Security/DevSecOps |
| Debugging complex systems | Open source | Developer experience |
| System design | Community building | Observability |

**Your niche**: Look for overlap across all three columns.

## Personal Brand Statement

Use this formula to craft your positioning:

> "I help **[target audience]** achieve **[specific outcome]** by **[your unique approach]**"

### Examples

- "I help backend developers build scalable APIs by sharing battle-tested patterns from enterprise systems"
- "I help teams adopt DevOps practices by breaking down complex concepts into actionable steps"
- "I help early-career developers navigate their first architecture decisions through practical examples"

## LinkedIn Strategy

### Profile Optimization

**Headline Formula:**
`[Role] | [Specialization] | [Value Proposition]`

**Examples:**

- "Senior Backend Engineer | Distributed Systems | Helping teams scale from 0 to 10M users"
- "Staff Developer | .NET & Clean Architecture | Writing about pragmatic software design"

### Post Structure: Hook-Story-Insight-CTA

1. **Hook** (Lines 1-2): Bold statement, question, or surprising fact that makes people click "see more"
2. **Story** (Body): Your personal experience, what happened, what you learned
3. **Insight** (Key takeaway): The lesson that's transferable to others
4. **CTA** (End): Question, invitation, or next step

### Five Storytelling Frames

Use these templates to generate content ideas:

| Frame | Template | Example |
| --- | --- | --- |
| **Learning the Hard Way** | "I [made mistake]. Here's what I learned..." | "I deployed to prod on Friday. Here's what I learned..." |
| **Behind the Build** | "Here's how we built [X] and why we chose [Y]..." | "Here's how we built our monitoring stack..." |
| **Before/After** | "We went from [problem] to [solution]. Here's how..." | "We went from 30s deploys to 3min. Here's how..." |
| **Contrarian Take** | "Everyone says [common belief]. But I think..." | "Everyone says microservices. But I think..." |
| **Question Flip** | "The question isn't [X], it's [Y]..." | "The question isn't 'which framework?' It's 'what problem?'" |

### Posting Best Practices

- **Frequency**: 2-3 times per week minimum for growth
- **Timing**: Weekday mornings (7-9 AM local time of your audience)
- **Format**: Short paragraphs, line breaks, no walls of text
- **Visuals**: Original photos (no text overlays) outperform stock images
- **Engagement**: Respond to every comment in first 2 hours

## Conference Speaking (CFP Writing)

### CFP Title Formula

**Structure:** `[What we did] + [Problem/Solution] + [Why it matters]`

**Examples:**

- "We Fine-Tuned ChatGPT, Then It Started Correcting Our CTO"
- "How Our AI Onboarding Bot Confused Three New Devs (And What We Changed)"
- "We Migrated to Microservices and Regretted It (For a While)"

**What makes titles work:**

- Implies a journey or story
- Promises truth, not perfection
- Sparks curiosity
- Has a human element

### Abstract Structure

1. **Hook** (1 sentence): Why should anyone care?
2. **Problem** (2-3 sentences): What challenge did you face?
3. **Approach** (2-3 sentences): What did you try?
4. **Outcome** (1-2 sentences): What happened? What did you learn?
5. **Takeaways** (3 bullets): What will attendees walk away with?

### Starting Small

Don't aim for KubeCon first. Build experience through:

1. **Internal talks**: Brown bags, tech shares, Friday demos
2. **Local meetups**: Language/framework-specific groups
3. **Lightning talks**: 5-10 minute low-stakes presentations
4. **Online communities**: Dev.to, Hashnode, virtual meetups
5. **Regional conferences**: Local tech events before major conferences

## Internal Visibility

Building your brand within your organization:

### Strategies

1. **Become the "go-to" person** for a specific topic
2. **Document and share** learnings from projects
3. **Lead internal tech talks** or lunch-and-learns
4. **Write internal blog posts** or wiki contributions
5. **Mentor** newer team members
6. **Volunteer for cross-team initiatives**
7. **Share wins** in team channels (without bragging)

### The BRAG Document

Keep a running list of accomplishments:

- Projects delivered and their impact
- Problems solved
- Mentorship provided
- Process improvements
- Skills developed
- Recognition received

Update weekly. Use for performance reviews, promotion cases, and resume updates.

## Promoting Without Feeling Salesy

### Mindset Shifts

| From (Salesy) | To (Value-Driven) |
| --- | --- |
| "Look what I did!" | "Here's what I learned that might help you" |
| "Hire me!" | "I've been thinking about this problem..." |
| "I'm an expert" | "I've made these mistakes so you don't have to" |
| Self-promotion | Knowledge sharing |

### The 80/20 Rule

- **80% value**: Educational content, insights, helping others
- **20% promotional**: Your achievements, announcements, opportunities

## References

For detailed guidance, see:

- `references/personal-brand-framework.md` - Complete niche discovery and positioning
- `references/linkedin-strategies.md` - Post templates, engagement tactics, profile optimization
- `references/cfp-writing.md` - Conference proposal examples and abstract templates
- `references/internal-visibility.md` - Organizational visibility tactics
- `references/storytelling-frames.md` - Content templates and story structures

## Related Commands

- `/soft-skills:craft-linkedin-post` - Generate LinkedIn posts with storytelling frames
- `/soft-skills:write-cfp` - Draft conference proposals
- `/soft-skills:brand-statement` - Develop personal brand positioning

## Anti-Patterns to Avoid

- **Being everywhere badly** vs. being excellent in one place
- **Copying others** vs. finding your authentic voice
- **Chasing vanity metrics** (likes) vs. meaningful connections
- **Inconsistency** - Starting strong, then disappearing
- **Corporate speak** - Writing like a press release instead of a human
- **Only promoting** - No value-add content
- **Waiting until "ready"** - You already have stories worth sharing

## Version History

- **v1.0.0** (2025-12-26): Initial release

---

## Last Updated

**Date:** 2025-12-26
**Model:** claude-opus-4-5-20251101
