# Salary Negotiation Reference

Complete guide to negotiating job offers, including preparation, tactics, scripts, and handling common scenarios.

## Mindset Shift

### Negotiation Is Expected

Most employers expect negotiation. Not negotiating often means:

- Leaving money on the table (average of 5-10%)
- Starting below peers for the same role
- Lower baseline for future raises

Recruiters have ranges - initial offers are rarely the maximum.

### It's Not Adversarial

Good negotiation is collaborative problem-solving:

- You want fair compensation for your work
- They want to hire talent at reasonable cost
- Both sides can win

## Pre-Negotiation Research

### Know the Market

Research before you have an offer:

| Source | What It Provides |
| ------ | ---------------- |
| levels.fyi | Tech company compensation data by level |
| Glassdoor | Salary ranges by company and role |
| Blind | Anonymous crowdsourced compensation |
| LinkedIn Salary | Aggregated salary insights |
| Your network | Real data from people in similar roles |

### Know Your Number

Before negotiating, determine:

1. **Your minimum** - Below this, you walk away
2. **Your target** - What you're aiming for
3. **Your ask** - What you'll initially request (above target)

**Example:**

- Minimum: $140K (below this, I decline)
- Target: $155K (I'd be happy here)
- Ask: $165K (gives room to meet at target)

### Know Your BATNA

**B**est **A**lternative **T**o **N**egotiated **A**greement

Your leverage depends on your alternatives:

- Other offers (strongest BATNA)
- Current job (if you're employed)
- Ability to wait (financial runway)

**Never negotiate from desperation.** If you need this job at any cost, you have no leverage.

## Timing

### During the Process

**Deflect early salary questions:**

> "I'd prefer to focus on whether we're a mutual fit first. I'm confident we can work out compensation if we both decide to move forward."

Or:

> "I'm looking for a competitive offer based on my experience and the role's requirements. What's the range you have budgeted?"

**If pressed:**

> "I'm targeting the $150-170K range based on my research for similar roles, but I'm flexible depending on total compensation."

### Wait for the Written Offer

Don't negotiate until you have:

- A formal written offer
- Clear details (salary, equity, benefits, start date)
- Time to review (at least 48 hours)

**Why written matters:**

- Verbal offers can change
- You need complete picture to negotiate holistically
- Demonstrates professionalism

## The Negotiation

### Use Email

Email negotiation is better because:

- You can think before responding
- Everything is documented
- Less emotional in the moment
- Easier to be precise

### The Counter-Offer Email

Structure:

1. Express enthusiasm
2. Thank them for the offer
3. State your counter with reasoning
4. Reaffirm interest

**Example Email:**

```text
Subject: Re: [Company] Offer - Excited to Discuss

Hi [Name],

Thank you so much for the offer - I'm genuinely excited about the opportunity
to join [Company] and contribute to [specific thing you're excited about].

After reviewing the offer and researching market rates for similar roles,
I'd like to discuss the compensation. Based on my experience with [relevant
skills] and data from levels.fyi and Glassdoor for [Role] in [Location],
I'm targeting a base salary in the $155-165K range.

I believe this reflects both the value I'll bring to the team and the
market rate for this level of experience. I'm also open to discussing
how we might bridge any gap through sign-on bonus or additional equity.

I'm very enthusiastic about this role and confident we can find an
arrangement that works for both of us. I'm happy to discuss further
if that would be helpful.

Best,
[Your name]
```

### Negotiate Holistically

If base salary is firm, negotiate other components:

| Component | How to Negotiate |
| --------- | ---------------- |
| Equity | More shares, accelerated vesting |
| Sign-on bonus | One-time payment to bridge salary gap |
| Start date | Earlier for faster income |
| Remote work | Days per week, full-time option |
| PTO | Additional vacation days |
| Professional development | Conference budget, education stipend |
| Title | Higher title for future leverage |
| Review timing | Earlier performance review (6mo vs 12mo) |

**Script for holistic negotiation:**

> "I understand the base salary range is firm. Could we explore other ways to close the gap? I'd be happy to discuss a sign-on bonus or additional equity."

## Common Scenarios

### They Accept Immediately

If they accept your first counter without pushback, you may have asked too low.

**It's fine.** Take the win. You can negotiate harder next time.

### They Say "This Is Our Best Offer"

Options:

1. **Accept it** - If it meets your minimum
2. **Try one more time** - "Is there any flexibility on [specific component]?"
3. **Walk away** - If below your minimum

**Script:**

> "I appreciate you sharing that. Could you help me understand if there's any flexibility on [sign-on bonus / equity / start date]? I want to make this work."

### They Rescind the Offer

Very rare at legitimate companies. If it happens:

- They probably weren't a good employer anyway
- You likely dodged a bullet
- Don't let fear of this prevent negotiating

### They Need an Answer Immediately

**Red flag.** Reasonable employers give time to consider.

**Script:**

> "I'm very interested in this role, but I need time to consider such an important decision. Could we schedule a call for [2-3 days out] to discuss?"

If they refuse, reconsider whether you want to work there.

### Lowball Offer

When an offer is significantly below expectations:

1. **Don't react immediately** - "Thank you, let me review this and get back to you"
2. **Ask for their reasoning** - "Can you help me understand how you arrived at this number?"
3. **Counter with data** - Not emotions, but market evidence
4. **Be willing to walk** - Some gaps can't be closed

**Script:**

> "Thank you for the offer. I have to be honest - this is significantly below what I was expecting based on my research for this role. The market data I've seen suggests $X-Y for similar positions. Can you help me understand the compensation philosophy here?"

## After Accepting

### Get It in Writing

Before accepting verbally, ensure the final offer is documented in writing with all negotiated terms.

### Don't Gloat

Keep negotiation details private. Your new colleagues don't need to know.

### Deliver Value

The best way to set up your next negotiation: exceed expectations and build a track record.

## What NOT to Do

### Don't

- Lie about other offers
- Give ultimatums you won't follow through
- Negotiate multiple times after accepting
- Be aggressive or adversarial
- Apologize for negotiating
- Accept on the spot (always take time)
- Discuss salary with future colleagues

### Do

- Be professional and respectful
- Express genuine enthusiasm
- Use data to support requests
- Be honest about your situation
- Take time to decide
- Get everything in writing
- Thank them regardless of outcome

## Scripts for Common Questions

### "What are your salary expectations?"

> "I'm looking for a competitive offer that reflects my experience. Based on my research, I'd expect something in the $X-Y range, but I'm focused on finding the right fit first."

### "What are you currently making?"

> "I'd prefer to focus on the value I'll bring to this role. What's the range you've budgeted for this position?"

(Note: In many jurisdictions, employers can't legally ask this.)

### "We don't have much flexibility on salary."

> "I understand. Are there other components we could discuss - like sign-on bonus, equity, or additional PTO?"

### "This is a firm offer."

> "I appreciate your transparency. Let me take a day to review everything and I'll get back to you."

## Negotiation Checklist

Before sending your counter:

- [ ] I've researched market rates from multiple sources
- [ ] I know my minimum, target, and ask numbers
- [ ] I have a clear BATNA (or acknowledge I don't)
- [ ] I'm expressing enthusiasm, not just demands
- [ ] I'm using data to support my position
- [ ] I've considered non-salary components
- [ ] I'm prepared for them to say no
- [ ] I have the offer in writing
