---
name: promotion-preparation
description: Building promotion cases, brag documents, tracking wins, and self-advocacy for career advancement. Use when preparing for promotions, documenting accomplishments, or building your case for advancement.
allowed-tools: Read, Glob, Grep
---

# Promotion Preparation

This skill provides frameworks for building compelling promotion cases, maintaining brag documents, tracking accomplishments, and effectively advocating for your career advancement.

## Keywords

promotion, brag document, promotion case, self-advocacy, wins, accomplishments, impact, career advancement, tracking wins, promotion document, manager alignment, performance review, evidence-based promotion

## When to Use This Skill

- Building a promotion case document
- Starting or maintaining a brag document
- Tracking and categorizing accomplishments
- Preparing for performance reviews
- Understanding what managers look for
- Learning to advocate for yourself
- Documenting impact and contributions

## Core Principle: You Own Your Promotion

**Critical insight:** Promotions are not handed out - they are earned and advocated for.

Your manager:

- Cannot remember all your accomplishments
- Has limited time to build your case
- Needs your help to advocate for you
- Wants you to succeed but needs evidence

**Your responsibility:**

- Track your own wins consistently
- Build your promotion case proactively
- Communicate impact clearly
- Align with manager on expectations
- Make it easy for your manager to promote you

## The Promotion Case Document

A promotion case document is your comprehensive argument for advancement. It serves multiple purposes:

- Provides evidence for promotion discussions
- Helps your manager advocate for you
- Forces you to articulate your impact
- Identifies gaps you can address

### Three-Section Structure

#### 1. Accomplishments & Impact (What You've Done)

Document specific achievements with measurable outcomes:

- Projects delivered and their business impact
- Problems solved and value created
- Technical contributions and innovations
- Process improvements and efficiency gains

#### 2. Growth & Learning (How You've Developed)

Show trajectory and development:

- Skills acquired or deepened
- Challenges overcome
- Feedback incorporated
- Areas of improvement demonstrated

#### 3. Future Focus (What You'll Do Next)

Demonstrate readiness for next level:

- Goals aligned to next-level expectations
- Larger scope you're ready to take on
- Development areas you're addressing
- Vision for your expanded role

## Brag Document Fundamentals

A brag document (also called "work log" or "wins journal") is your ongoing record of accomplishments.

### Why Keep a Brag Document?

- **Memory is unreliable:** You forget 80% of what you did by review time
- **Recency bias:** Recent work overshadows earlier achievements
- **Cumulative impact:** Small wins add up to significant patterns
- **Confidence building:** Reviewing wins combats imposter syndrome
- **Interview prep:** Ready-made STAR stories for future opportunities

### Cadence

| Frequency | Activity |
| --------- | -------- |
| Weekly | Quick bullet points of wins (5-10 min) |
| Monthly | Review and expand bullets, add context |
| Quarterly | Synthesize themes, identify patterns |
| Annually | Build promotion case from accumulated evidence |

### What to Capture

For each win, capture:

- **What:** The specific accomplishment
- **How:** Your approach and actions
- **Impact:** Measurable outcomes (quantify when possible)
- **Skills:** What this demonstrates
- **Category:** Type of contribution (see Win Categorization)

## Win Categorization

Not all wins are created equal. Categorize to show breadth:

### Impact Types

| Type | Description | Example |
| ---- | ----------- | ------- |
| **Delivery** | Shipped features, projects, products | "Launched payment v2, processing $2M/day" |
| **Quality** | Improved reliability, reduced bugs | "Reduced error rate from 2% to 0.1%" |
| **Efficiency** | Faster, cheaper, better processes | "Cut deploy time from 2 hours to 15 min" |
| **Innovation** | New approaches, creative solutions | "Introduced caching strategy saving $50K/year" |
| **Leadership** | Mentoring, leading, enabling others | "Mentored 2 engineers to senior level" |
| **Collaboration** | Cross-team work, partnerships | "Led joint initiative with 3 teams" |

### Scope Levels

| Scope | Description | Next Level Signal |
| ----- | ----------- | ----------------- |
| **Individual** | Your personal contribution | Expected at current level |
| **Team** | Improved your team's outcomes | Mid → Senior |
| **Multi-team** | Impact across multiple teams | Senior → Staff |
| **Org-wide** | Shaped organizational outcomes | Staff → Principal |

## Self-Advocacy Skills

### Making Your Work Visible

Visibility is not self-promotion - it's professional communication:

1. **Status updates:** Regular, concise updates on progress
2. **Demo your work:** Present at team meetings, tech talks
3. **Document decisions:** Write design docs, ADRs, post-mortems
4. **Share learnings:** Blog posts, knowledge sharing sessions
5. **Volunteer for visibility:** All-hands demos, cross-team presentations

### Articulating Impact

**Weak:** "I worked on the new API"

**Strong:** "I designed and implemented the new payments API, which reduced integration time from 2 weeks to 2 days and enabled 3 new partner integrations in Q3"

**Formula:** Action + Specifics + Measurable Outcome

### Working with Your Manager

1. **Align on expectations:** What does next level look like specifically?
2. **Share your goals:** Make your promotion aspirations known
3. **Regular check-ins:** Use 1:1s to discuss progress
4. **Ask for feedback:** What gaps exist? What would make the case stronger?
5. **Request opportunities:** Ask for stretch assignments aligned to next level

## Common Mistakes

### In Tracking Wins

- **Waiting too long:** Weekly tracking beats quarterly scrambles
- **Being too modest:** Document everything, filter later
- **Only big wins:** Small wins show consistency
- **Skipping context:** Future-you won't remember details
- **No quantification:** Numbers make impact concrete

### In Building the Case

- **Too generic:** "I'm a good team player" vs specific examples
- **Missing business impact:** Technical achievements without business context
- **No growth narrative:** List of tasks vs story of development
- **Ignoring gaps:** Pretending weaknesses don't exist vs addressing them
- **Going alone:** Not aligning with manager throughout

### In Self-Advocacy

- **Assuming merit is enough:** Great work must be visible
- **Waiting to be noticed:** Proactive communication is expected
- **Over-advocating:** Balance confidence with humility
- **Wrong audience:** Tailor message to stakeholders
- **Timing:** Don't wait until review time to start

## Manager's Perspective

Understanding how managers view promotions helps you prepare effectively:

**What managers need:**

- Clear evidence to present to their managers
- Confidence that you'll succeed at next level
- Reduced risk of "promoting too early"
- Peer-level support for the promotion

**What makes promotion easy:**

- Well-documented accomplishments with impact
- Already operating at next level
- No significant concerns or gaps
- Clear narrative they can tell

**What makes promotion hard:**

- Vague contributions hard to articulate
- Gaps in critical competencies
- Inconsistent performance
- Lack of peer support or visibility

## Building Your Promotion Timeline

### 6 Months Before Review

- Start or refresh brag document
- Align with manager on promotion goals
- Identify gaps and create development plan
- Seek stretch assignments

### 3 Months Before Review

- Begin drafting promotion case
- Review against next-level expectations
- Gather supporting evidence (docs, metrics)
- Get feedback on draft from manager

### 1 Month Before Review

- Finalize promotion document
- Ensure manager has everything needed
- Prepare talking points
- Document recent wins

### At Review Time

- Be prepared to discuss your case
- Listen to feedback openly
- If not promoted, understand gaps and plan
- Continue tracking for next cycle

## References

For detailed guidance, see:

- `references/promotion-case-structure.md` - Complete promotion document template with examples
- `references/brag-document-guide.md` - Weekly/monthly tracking templates and tips
- `references/win-categorization.md` - Multi-dimensional win classification framework
- `references/manager-perspective.md` - What managers look for, how to align

## Related Skills

- `career-progression` - Level expectations and progression paths
- `career-strategy` - Internal vs external growth decisions
- `interview-skills` - Using accomplishments in interviews

## Related Commands

- `/soft-skills:build-promotion-case` - Generate a structured promotion case document
- `/soft-skills:track-win` - Document an accomplishment in brag document format

## Version History

- **v1.0.0** (2025-12-26): Initial release

---

## Last Updated

**Date:** 2025-12-26
**Model:** claude-opus-4-5-20251101
