# Win Categorization Reference

A multi-dimensional framework for categorizing accomplishments to build a comprehensive promotion case.

## Why Categorize Wins?

1. **Show breadth:** Promotions require demonstrating multiple competencies
2. **Identify gaps:** See where you're light and need more examples
3. **Tell a story:** Organize wins into a coherent narrative
4. **Match expectations:** Align with your company's level framework

---

## Dimension 1: Impact Type

Classify wins by the type of value they created.

### Delivery

**Definition:** Shipping features, products, projects, or capabilities

**Examples:**

- "Launched new payment integration, processing $2M/day"
- "Shipped mobile app v2, achieving 50K downloads in first month"
- "Completed migration on schedule, zero downtime"

**Signals:** Ability to execute, drive to completion, reliability

### Quality

**Definition:** Improving reliability, reducing bugs, increasing stability

**Examples:**

- "Reduced error rate from 2% to 0.1%"
- "Increased test coverage from 40% to 85%"
- "Eliminated flaky tests, CI reliability now 99%"

**Signals:** Attention to detail, sustainable engineering, craftsmanship

### Efficiency

**Definition:** Faster, cheaper, or more streamlined processes and systems

**Examples:**

- "Cut deploy time from 2 hours to 15 minutes"
- "Reduced infrastructure costs by 30%"
- "Automated manual process, saving 5 hours/week"

**Signals:** Optimization mindset, resource awareness, pragmatism

### Innovation

**Definition:** New approaches, creative solutions, novel techniques

**Examples:**

- "Introduced caching strategy saving $50K/year"
- "Developed new testing approach adopted by 3 teams"
- "Created internal tool used by 50 engineers"

**Signals:** Creativity, forward thinking, problem-solving

### Leadership

**Definition:** Mentoring, leading people, enabling others' success

**Examples:**

- "Mentored 2 engineers, both promoted within year"
- "Led team of 4 through complex migration"
- "Established onboarding program, 50% faster ramp-up"

**Signals:** Multiplier effect, people development, influence

### Collaboration

**Definition:** Cross-team work, partnerships, stakeholder management

**Examples:**

- "Led joint initiative with platform, mobile, and data teams"
- "Established partnership with external vendor"
- "Bridged gap between engineering and product on feature definition"

**Signals:** Communication, relationship building, organizational navigation

---

## Dimension 2: Scope Level

Classify wins by how widely they impacted the organization.

### Individual Scope

**Definition:** Your personal contribution, direct output

**Examples:**

- "Wrote module handling authentication flow"
- "Debugged and fixed critical production issue"
- "Implemented feature according to spec"

**Level Signal:** Expected at all levels; alone doesn't signal seniority

### Team Scope

**Definition:** Impact on your immediate team's outcomes

**Examples:**

- "Introduced code review practices, team bug rate down 30%"
- "Led project requiring coordination across 4 team members"
- "Mentored junior engineer, accelerated their productivity"

**Level Signal:** Mid → Senior transition

### Multi-Team Scope

**Definition:** Impact spanning multiple teams or domains

**Examples:**

- "Led initiative involving engineering, product, and design"
- "Created shared library adopted by 3 teams"
- "Established cross-team standards for API design"

**Level Signal:** Senior → Staff transition

### Org-Wide Scope

**Definition:** Impact at organizational or company level

**Examples:**

- "Defined technical strategy adopted across engineering"
- "Led company-wide migration affecting 15 teams"
- "Established engineering-wide interviewing standards"

**Level Signal:** Staff → Principal transition

---

## Dimension 3: Competency Category

Align wins with standard engineering competencies.

### Technical/Implementation

- Code quality and best practices
- Debugging and problem-solving
- Performance and optimization
- Security and reliability

### Design

- System architecture
- Technical decision-making
- Problem decomposition
- Documentation

### Operations

- Incident response
- Monitoring and observability
- Production ownership
- On-call and reliability

### Product

- Business understanding
- Customer focus
- Requirements translation
- Impact measurement

### Leadership

- Mentoring and teaching
- Project leadership
- Influence and persuasion
- Culture building

### Communication

- Written documentation
- Verbal presentation
- Cross-functional communication
- Stakeholder management

---

## Win Categorization Matrix

Use this matrix to analyze your portfolio of wins:

```text
                    | Individual | Team | Multi-Team | Org-Wide
--------------------|------------|------|------------|----------
Delivery            |            |      |            |
Quality             |            |      |            |
Efficiency          |            |      |            |
Innovation          |            |      |            |
Leadership          |            |      |            |
Collaboration       |            |      |            |
```

**Instructions:**

1. Place each win in the appropriate cell
2. Look for empty cells = gaps to address
3. Look for clusters = strengths to highlight
4. Compare to next-level expectations

---

## Win Categorization Template

For each accomplishment, capture:

```markdown
## [Win Title]

**Summary:** [One-sentence description]

**Impact Type:** [Delivery/Quality/Efficiency/Innovation/Leadership/Collaboration]

**Scope Level:** [Individual/Team/Multi-Team/Org-Wide]

**Competencies Demonstrated:**
- [Competency 1]
- [Competency 2]

**Quantified Impact:**
- [Metric 1]
- [Metric 2]

**Evidence/Links:**
- [Link to design doc, PR, dashboard, etc.]
```

---

## Using Categories for Promotion Cases

### Building a Balanced Portfolio

**For Mid → Senior:**

- Majority of wins should be Team scope or higher
- Show Leadership and Collaboration impact types
- Demonstrate multiple competency categories

**For Senior → Staff:**

- Significant Multi-Team scope wins
- Innovation and Leadership impact types prominent
- Evidence of organizational influence

### Addressing Gaps

If your matrix shows gaps:

1. **Actively seek opportunities** in weak areas
2. **Reframe existing work** to highlight missing categories
3. **Document "invisible" contributions** you may have overlooked
4. **Create opportunities** for yourself (propose projects, volunteer)

### Telling a Story

Organize wins to tell a coherent narrative:

**Chronological:** Show growth over time
**Thematic:** Group by impact type or competency
**Progressive:** Show increasing scope
**Problem-Solution:** Frame around challenges overcome

---

## Examples by Level Transition

### Junior → Mid Examples

| Win | Impact Type | Scope |
| --- | ----------- | ----- |
| Implemented user profile feature with 90% test coverage | Delivery + Quality | Individual |
| Reduced page load time by identifying inefficient query | Efficiency | Individual |
| Created documentation for onboarding new team members | Collaboration | Team |
| Mentored intern through summer project | Leadership | Individual |

### Mid → Senior Examples

| Win | Impact Type | Scope |
| --- | ----------- | ----- |
| Led migration to new payment provider, zero downtime | Delivery | Team |
| Designed and implemented caching layer, 60% latency reduction | Innovation + Efficiency | Team |
| Mentored 2 junior engineers, both promoted within year | Leadership | Team |
| Created testing framework adopted by 3 teams | Innovation | Multi-Team |

### Senior → Staff Examples

| Win | Impact Type | Scope |
| --- | ----------- | ----- |
| Architected microservices strategy for payments domain | Delivery + Innovation | Multi-Team |
| Established code review standards adopted company-wide | Quality + Leadership | Org-Wide |
| Led cross-team initiative reducing deploy time by 70% | Efficiency + Collaboration | Multi-Team |
| Mentored 3 engineers to senior level | Leadership | Team |

---

## Anti-Patterns

### Only One Impact Type

**Problem:** All wins are "Delivery" - shows execution but not other skills

**Fix:** Actively document efficiency, leadership, collaboration wins

### Only Individual Scope

**Problem:** All wins are your personal contribution - doesn't show influence

**Fix:** Look for ways your work impacted the team or beyond

### Missing Competency Categories

**Problem:** No wins in Leadership or Communication categories

**Fix:** Document mentoring, presentations, documentation, stakeholder work

### No Quantification

**Problem:** Wins lack measurable impact

**Fix:** Add metrics retroactively where possible, estimate if needed
