---
name: resume-optimization
description: Resume structure, achievement bullet formulas, ATS optimization, and job-targeted tailoring for software engineers. Use when reviewing resumes, crafting achievement bullets, extracting keywords from job descriptions, or tailoring content for specific roles.
allowed-tools: Read, Glob, Grep
---

# Resume Optimization

Comprehensive guidance for creating effective software engineering resumes that pass ATS systems and resonate with hiring managers.

## When to Use This Skill

- Reviewing or improving a software engineer's resume
- Crafting impactful achievement bullets from work experience
- Optimizing resume content for ATS keyword matching
- Tailoring a resume for a specific job description
- Understanding modern resume structure and formatting

## Core Principles

### The Resume's Purpose

A resume is a **marketing document**, not a job history. Its purpose is to:

1. Pass ATS screening (keyword matching)
2. Capture a recruiter's attention (6-second scan)
3. Demonstrate value through quantified achievements
4. Secure an interview opportunity

### What Makes Engineering Resumes Different

Software engineering resumes should emphasize:

- **Technical impact**: Specific technologies, scale, and performance improvements
- **Business outcomes**: Revenue, cost savings, user growth, time savings
- **Leadership signals**: Mentoring, cross-team collaboration, technical decisions
- **Quantification**: Numbers that demonstrate scope and impact

## Resume Structure Quick Reference

### Recommended Section Order

1. **Contact Information** - Name, email, phone, LinkedIn, GitHub (optional)
2. **Professional Summary** (optional) - 2-3 sentences for senior roles
3. **Skills** - Technical skills organized by category
4. **Experience** - Reverse chronological, 3-5 most relevant roles
5. **Projects** (optional) - For junior engineers or career changers
6. **Education** - Degrees, certifications, relevant coursework

### Length Guidelines

| Experience Level | Recommended Length |
| ---------------- | ------------------ |
| 0-5 years | 1 page |
| 5-10 years | 1-2 pages |
| 10+ years | 2 pages max |

### Formatting Essentials

- **Font**: Clean, readable (Calibri, Arial, Garamond - 10-12pt)
- **Margins**: 0.5-1 inch
- **Format**: PDF (preserves formatting)
- **File naming**: `FirstName_LastName_Resume.pdf`

## Achievement Bullet Formula

### Action Verb + Specific Task + Quantifiable Result

```text
[Strong Action Verb] [specific task/project] using [tools/methods], resulting in [quantified outcome].
```

### Strong Action Verbs by Category

| Category | Verbs |
| -------- | ----- |
| Technical | Architected, Built, Deployed, Engineered, Implemented, Integrated, Migrated, Optimized, Refactored, Scaled |
| Design | Analyzed, Designed, Documented, Modeled, Prototyped, Researched, Specified |
| Leadership | Championed, Coached, Led, Mentored, Pioneered, Spearheaded |
| Impact | Achieved, Boosted, Delivered, Improved, Increased, Reduced, Saved, Streamlined |

### Quantification Types

- **Time**: "Reduced deploy time from 2 hours to 15 minutes"
- **Money**: "Saved $50K/year in infrastructure costs"
- **Scale**: "Scaled system to handle 1M daily requests"
- **Improvement**: "Improved test coverage from 40% to 85%"
- **Frequency**: "Reduced support tickets by 70%"

## ATS Optimization

### What ATS Systems Look For

1. **Keyword matching** - Skills, tools, technologies from job description
2. **Job title alignment** - Titles that match or relate to the target role
3. **Section structure** - Standard sections that ATS can parse
4. **Clean formatting** - No tables, columns, graphics, or headers/footers

### ATS-Friendly Practices

- Use standard section headings ("Experience", "Skills", "Education")
- Include both spelled-out terms AND acronyms ("Continuous Integration (CI)")
- Mirror exact phrases from job descriptions
- Avoid images, icons, or non-text elements
- Use bullet points (-, *, •) not custom symbols

### Keyword Extraction Strategy

When tailoring for a job description:

1. **Identify required skills** - Listed in "Required" or "Must have" sections
2. **Note preferred skills** - Listed in "Nice to have" or "Preferred"
3. **Capture soft skills** - Leadership, communication, collaboration terms
4. **Extract action verbs** - What the job says you'll "do" or "lead"
5. **Match technologies** - Specific tools, languages, frameworks mentioned

## Tailoring Strategy

### The 80/20 Rule

- **80% base resume**: Core experience and skills that apply broadly
- **20% customization**: Targeted adjustments for each application

### What to Customize

1. **Professional Summary** - Align with job's key requirements
2. **Skills Section** - Reorder to prioritize job's requirements
3. **Achievement Bullets** - Emphasize relevant accomplishments
4. **Keywords** - Incorporate exact terms from job description

### Red Flags to Avoid

- Generic objective statements ("Seeking a challenging position...")
- Job duties instead of achievements ("Responsible for...")
- Unexplained gaps without context
- Typos or inconsistent formatting
- Outdated technologies prominently featured

## References

For detailed guidance on specific topics:

- [Resume Structure Guide](references/resume-structure.md) - Section order, formatting, length
- [Achievement Formula Guide](references/achievement-formula.md) - Transforming experience into impact
- [ATS Keywords Guide](references/ats-keywords.md) - Keyword extraction and optimization
- [Tailoring Guide](references/tailoring-guide.md) - Matching resume to job description

## Related Resources

- `achievement-bullet` output style - Format for achievement bullets
- `/soft-skills:craft-achievement` command - Transform descriptions into bullets
- `/soft-skills:tailor-resume` command - Adapt resume for specific job
- `resume-coach` agent - Interactive resume improvement

## Version History

- v1.0.0 (2025-12-23): Initial release with core resume optimization guidance
