# Resume Structure Guide

Comprehensive guidance on resume section order, formatting, and length for software engineers at all experience levels.

## Section Order and Purpose

### 1. Contact Information (Required)

**Purpose:** Enable recruiters to reach you.

**Include:**

- Full name (professional name you use)
- Professional email (<firstname.lastname@domain.com> preferred)
- Phone number with area code
- LinkedIn URL (customized if possible)
- GitHub/Portfolio (optional, if strong)
- Location (City, State or "Open to Remote")

**Omit:**

- Full street address (security risk, rarely needed)
- Personal social media
- Photo (in US, can introduce bias)

### 2. Professional Summary (Conditional)

**Include if:**

- 5+ years of experience
- Making a career transition
- Targeting a specific role type

**Structure (2-3 sentences):**

```text
[Years of experience] [role/specialty] with expertise in [key technologies].
[Key achievement or differentiator]. [What you're seeking or offering].
```

**Example:**
> Senior Backend Engineer with 8 years building high-scale distributed systems
> in fintech and e-commerce. Led teams that processed $2B+ in annual transactions
> with 99.99% uptime. Seeking to apply systems design expertise at a Series B+
> startup tackling infrastructure challenges.

**Omit if:**

- Less than 3 years experience
- Summary would be generic/filler

### 3. Skills Section (Required)

**Purpose:** Quick-scan for recruiters, keyword matching for ATS.

**Organization Options:**

**By Category:**

```text
Languages: Python, Java, TypeScript, Go
Frameworks: React, Django, Spring Boot, Node.js
Cloud/Infra: AWS (EC2, Lambda, S3), Kubernetes, Docker, Terraform
Databases: PostgreSQL, MongoDB, Redis, Elasticsearch
Tools: Git, Jenkins, Datadog, Jira
```

**By Proficiency (less common but useful):**

```text
Expert: Python, PostgreSQL, AWS
Proficient: Java, Kubernetes, React
Familiar: Go, GraphQL, Terraform
```

**Best Practices:**

- List 15-25 relevant skills
- Order by relevance to target role
- Include both technologies and methodologies (Agile, TDD, CI/CD)
- Update for each application to match job requirements

### 4. Experience Section (Required)

**Purpose:** Demonstrate value through past work.

**Format per Role:**

```text
Job Title | Company Name
Location | Start Date - End Date (or "Present")

• Achievement bullet 1 (most impactful)
• Achievement bullet 2
• Achievement bullet 3
• Achievement bullet 4-5 (for more senior roles)
```

**Ordering:**

- Reverse chronological (most recent first)
- Include 3-5 most relevant positions
- Older positions can be condensed to 1-2 bullets

**Date Formatting:**

- Use "Month Year - Month Year" format (Jan 2022 - Present)
- Be consistent throughout
- Short gaps (< 3 months) don't need explanation

### 5. Projects Section (Conditional)

**Include if:**

- Junior engineer (< 2 years experience)
- Career changer with relevant side projects
- Open source contributions worth highlighting

**Format:**

```text
Project Name | Technologies Used
Brief description (1 line)
• Key achievement or feature
• Quantified impact if applicable
Link: github.com/username/project
```

**Omit if:**

- Strong work experience makes projects redundant
- Projects are trivial (basic tutorials, coursework)

### 6. Education Section (Required, but position varies)

**Position:**

- At bottom for experienced professionals (5+ years)
- Near top for recent graduates (< 2 years)

**Format:**

```text
Degree, Major | University Name
Graduation Year
• Relevant honors, GPA (if strong), activities
```

**What to Include:**

- Degrees (include in-progress with expected date)
- Bootcamps (if substantial and relevant)
- Relevant certifications (AWS, Google Cloud, etc.)

**What to Omit:**

- High school (unless prestigious or recent)
- GPA if below 3.5 (or omit entirely after 2+ years experience)
- Coursework (unless directly relevant and recent)

## Length Guidelines

### One Page Resume

**Best for:**

- 0-5 years experience
- Career changers (focus on transferable skills)
- When explicitly requested by employer

**Strategies:**

- Maximum 3-4 positions
- 2-4 bullets per position
- No projects section if experience is strong
- Condensed skills section

### Two Page Resume

**Best for:**

- 10+ years experience
- Senior/Staff level and above
- Roles requiring broad experience (consulting, architecture)

**Page 1 Should Contain:**

- All contact info and summary
- Skills section
- Most recent 2 positions (full detail)

**Page 2 Can Contain:**

- Earlier positions
- Projects, publications, patents
- Extended education/certifications
- Speaking engagements, awards

### The 1.5 Page Trap

Avoid resumes that are:

- 1.5 pages (looks unpolished)
- One page of content with large margins/fonts

Either fill the page appropriately or cut to one page.

## Formatting Best Practices

### Typography

| Element | Recommendation |
| ------- | -------------- |
| Font Family | Calibri, Arial, Garamond, Georgia |
| Body Size | 10-11pt |
| Header Size | 12-14pt |
| Name Size | 14-18pt |
| Line Spacing | 1.0-1.15 |

### Layout

- **Margins:** 0.5-1.0 inch (smaller margins = more content)
- **Columns:** Single column for ATS compatibility
- **Alignment:** Left-aligned body text
- **Bullets:** Standard bullets (-, *, •)

### Visual Elements

**Include:**

- Bold for job titles and company names
- Consistent date formatting
- Clear section dividers (lines or spacing)

**Avoid:**

- Graphics, charts, or icons
- Photos or headshots
- Colored backgrounds or sidebars
- Tables or multi-column layouts
- Headers/footers (ATS parsing issues)

## File Format and Naming

### File Format

**PDF** (preferred):

- Preserves formatting across systems
- Universal compatibility
- ATS-friendly when text-based

**DOCX** (alternative):

- When specifically requested
- For systems that require it
- Some older ATS prefer .docx

**Avoid:**

- Google Docs links (may not open)
- Images or scanned documents
- Non-standard formats

### File Naming

**Convention:**

```text
FirstName_LastName_Resume.pdf
John_Smith_Resume.pdf
```

**Alternatives:**

```text
FirstName_LastName_SWE_Resume.pdf
FirstName_LastName_Resume_2024.pdf
```

**Avoid:**

```text
Resume.pdf (too generic)
Resume-v4-final-FINAL.pdf (unprofessional)
```

## Version Control Strategy

### Base Resume

Maintain a "master" resume with:

- All experience (even if not always included)
- Complete skills inventory
- All projects and education
- Extra bullets for each role

### Tailored Versions

Create targeted versions for:

- Different role types (Backend vs. Full-Stack)
- Different industries (FinTech vs. HealthTech)
- Specific companies (extensive customization)

### Tracking System

Simple spreadsheet tracking:

- Company name
- Position title
- Date applied
- Version used
- Status/notes
