# Team Dynamics Patterns

Common team dysfunctions, their symptoms, and proven remedies.

## The Five Dysfunctions of a Team

Based on Patrick Lencioni's widely-used model, these dysfunctions build on each other in a pyramid.

### Dysfunction 1: Absence of Trust

**Definition:** Unwillingness to be vulnerable within the group.

**Symptoms:**

- Team members hide weaknesses and mistakes
- Reluctance to ask for help or feedback
- Jumping to conclusions about intentions
- Holding grudges
- Dreading meetings

**Root cause:** Fear of being judged, punished, or seen as weak.

**Remedies:**

1. **Personal history exercise:** Share non-work backgrounds
2. **Leader vulnerability:** Model admitting mistakes first
3. **360 feedback:** Create structured feedback mechanisms
4. **Team assessments:** Share working styles and preferences
5. **Regular retrospectives:** Normalize discussing what went wrong

**Key behavior change:** Team members say "I was wrong" and "I need help."

### Dysfunction 2: Fear of Conflict

**Definition:** Artificial harmony instead of productive ideological conflict.

**Symptoms:**

- Boring meetings without debate
- Passive-aggressive behavior
- Personal attacks instead of idea debate
- Avoiding controversial topics
- Quick, unexamined consensus

**Root cause:** Without trust, conflict feels dangerous.

**Remedies:**

1. **Mine for conflict:** "What are we not discussing?"
2. **Real-time permission:** "I'm going to push back on this - that's allowed, right?"
3. **Assign devil's advocate:** Rotate responsibility to challenge
4. **Thomas-Kilmann assessment:** Understand conflict styles
5. **Conflict norms:** Establish rules for healthy debate

**Key behavior change:** Team engages in debate around ideas without hesitation.

### Dysfunction 3: Lack of Commitment

**Definition:** Failure to commit to decisions.

**Symptoms:**

- Ambiguity about direction and priorities
- Rehashing decisions repeatedly
- Second-guessing decisions after they're made
- Delay waiting for more data
- Missed opportunities from indecision

**Root cause:** Without healthy conflict, people don't buy in.

**Remedies:**

1. **Disagree and commit:** Voice disagreement, then support decision
2. **Cascading messaging:** Leaders communicate decisions consistently
3. **Clear deadlines:** Force decisions by date
4. **Worst-case scenario:** "What's the worst if we're wrong?"
5. **Low-risk exposure:** Start small, iterate

**Key behavior change:** Team leaves meetings clear about what was decided.

### Dysfunction 4: Avoidance of Accountability

**Definition:** Failure to call out counterproductive behavior.

**Symptoms:**

- Resentment among high performers
- Mediocrity accepted
- Missed deadlines without consequence
- Leader is sole source of accountability
- Blame culture when things go wrong

**Root cause:** Without commitment, it feels unfair to hold others accountable.

**Remedies:**

1. **Public goals and standards:** Make expectations visible
2. **Regular progress reviews:** Create rhythm of accountability
3. **Peer accountability:** Team members hold each other to standards
4. **Team rewards:** Tie incentives to team outcomes
5. **Real consequences:** Address non-performance, including exits

**Key behavior change:** Team members call out behavior that hurts the team.

### Dysfunction 5: Inattention to Results

**Definition:** Prioritizing individual status/ego over collective results.

**Symptoms:**

- Individual achievement over team success
- Status and ego dominate decisions
- Team stagnates while individuals advance
- Distractable by new opportunities
- No collective celebration

**Root cause:** Without accountability, individuals optimize for themselves.

**Remedies:**

1. **Public declaration of results:** Make goals visible to everyone
2. **Results-based rewards:** Tie compensation to team outcomes
3. **Celebrate team wins:** Recognize collective achievements
4. **OKRs or similar:** Align individual goals to team goals
5. **Team scoreboard:** Real-time visibility into progress

**Key behavior change:** Team prioritizes collective goals over individual advancement.

## Other Common Dysfunctions

### The Groupthink Pattern

**Definition:** Conformity pressure suppresses dissenting opinions.

**Symptoms:**

- Unanimous decisions with no discussion
- "Obviously this is the right answer"
- Outsiders surprised by team decisions
- Dismissal of external criticism
- Rationalizing away warning signs

**Remedies:**

- Assign devil's advocate role
- Seek external input before decisions
- Anonymous voting before discussion
- Encourage "what if we're wrong?"
- Delay decisions to allow dissent to emerge

### The Hero Culture

**Definition:** Reliance on individual heroics rather than sustainable teamwork.

**Symptoms:**

- Consistent crunch and burnout
- "Indispensable" individuals
- Celebration of overwork
- Single points of failure
- Knowledge hoarding

**Remedies:**

- Celebrate process improvements over heroics
- Document and share knowledge
- Rotate responsibilities
- Address systemic causes of crunch
- Model sustainable work patterns

### The Blame Culture

**Definition:** Focusing on who caused a problem rather than solving and preventing it.

**Symptoms:**

- Defensive behavior after incidents
- CYA documentation
- Hiding problems until they explode
- Investigation = interrogation
- Fear of admitting mistakes

**Remedies:**

- Blameless post-mortems
- Focus on systems, not individuals
- Leader modeling of admitting mistakes
- Celebrate learning from failures
- Systemic fixes over individual punishment

### The Consensus Trap

**Definition:** Requiring everyone to agree before moving forward.

**Symptoms:**

- Slow decisions
- Lowest common denominator solutions
- Exhausting discussions without resolution
- Tyranny of the minority holdout
- Passive resistance after "consensus"

**Remedies:**

- Clarify decision-making authority
- Use "disagree and commit"
- Time-box decisions
- Establish "good enough for now"
- Not all decisions require consensus

### The Silo Pattern

**Definition:** Teams optimizing locally at expense of broader organization.

**Symptoms:**

- "Not my problem" attitude
- Duplicated work
- Finger-pointing between teams
- Poor handoffs
- Information hoarding

**Remedies:**

- Cross-functional goals
- Rotation or embedding programs
- Shared success metrics
- Clear interfaces and contracts
- Joint retrospectives

## Team Stages and Dynamics

### Tuckman's Stages

Teams typically move through stages:

#### 1. Forming

- Polite, uncertain
- Looking to leader for direction
- Testing boundaries
- *Need:* Clear goals, structure, welcome

#### 2. Storming

- Conflict emerges
- Power struggles
- Frustration with differences
- *Need:* Healthy conflict skills, patience, norms

#### 3. Norming

- Cohesion develops
- Roles clarify
- Agreements form
- *Need:* Reinforcement, documentation of norms

#### 4. Performing

- High productivity
- Autonomous problem-solving
- Mutual support
- *Need:* Continued attention, not complacency

#### 5. Adjourning (for temporary teams)

- Wrapping up
- Transition and handoff
- *Need:* Celebration, knowledge capture, closure

### Stage Implications

**Don't skip storming:**
Teams that avoid conflict in storming often get stuck in pseudo-norming with unresolved tensions.

**Re-storming happens:**
Team changes (new members, departures, reorgs) can push teams back to earlier stages.

**Not linear:**
Teams may move back and forth between stages based on circumstances.

## Diagnostic Questions

### For Team Leaders

- When did team members last admit a mistake openly?
- How was the last significant disagreement handled?
- Is there anything team members wouldn't tell me?
- Who speaks most in meetings? Least?
- When did we last celebrate a team win vs. individual achievement?

### For Team Members

- Can I bring up problems without fear?
- Do I feel my perspective is valued?
- Am I clear about team goals and my role?
- Would I ask for help from anyone on the team?
- Do I trust my teammates to deliver their commitments?

### For the Whole Team

- What's the most important thing we're not discussing?
- If this team were 10x more effective, what would be different?
- What's holding us back?
- What norm do we have that no longer serves us?
- Who would leave if they had another option? Why?

## Intervention Strategies

### When to Intervene

**Low urgency, low complexity:**

- Address in regular team forums
- Coach individuals 1:1
- Use team rituals (retros)

**High urgency or complexity:**

- Dedicate time specifically to team health
- Bring in neutral facilitator
- Consider team-building offsite
- May need leadership changes

### How to Intervene

#### 1. Diagnose

- Observe and gather data
- Individual conversations
- Anonymous surveys
- External perspective

#### 2. Build awareness

- Share observations with team
- Create shared understanding
- Avoid blame

#### 3. Commit to change

- Agree on specific actions
- Assign ownership
- Set timeline

#### 4. Practice and reinforce

- Consistent follow-through
- Regular check-ins
- Celebrate progress

#### 5. Sustain

- Embed in regular processes
- Monitor for regression
- Adapt as team evolves
