---
name: doctrine-assessment
description: Assess organizational doctrine and universally useful patterns
allowed-tools: Read, Glob, Grep, Write, Edit
---

# Doctrine Assessment Skill

Assess organizational doctrine using Simon Wardley's universally useful patterns for organizational effectiveness.

## When to Use This Skill

Use this skill when:

- **Doctrine Assessment tasks** - Working on assess organizational doctrine and universally useful patterns
- **Planning or design** - Need guidance on Doctrine Assessment approaches
- **Best practices** - Want to follow established patterns and standards

## MANDATORY: Documentation-First Approach

Before assessing doctrine:

1. **Invoke `docs-management` skill** for doctrine patterns
2. **Verify Wardley doctrine phases** via MCP servers (perplexity)
3. **Base guidance on Wardley's doctrine catalog**

## What is Doctrine?

```text
Doctrine = Universally Useful Patterns

These are principles that:
- Apply regardless of context
- Are valuable in any organization
- Don't depend on landscape position
- Support strategic effectiveness

Doctrine ≠ Strategy
- Strategy: Context-dependent positioning
- Doctrine: Universal best practices
```

## Doctrine Categories

### Phase I: Stop Self-Inflicted Harm

```text
FOUNDATIONAL DOCTRINE:

1. KNOW YOUR USERS
   - Understand who you're serving
   - Research actual needs (not assumed)
   - Regular user engagement
   Assessment: Who are your users? When did you last talk to them?

2. USE A COMMON LANGUAGE
   - Shared vocabulary across organization
   - Maps as communication tool
   - Avoid departmental jargon
   Assessment: Can everyone understand strategic discussions?

3. CHALLENGE ASSUMPTIONS
   - Question "obvious" truths
   - Test beliefs with evidence
   - Avoid sacred cows
   Assessment: When did you last challenge a core assumption?

4. FOCUS ON USER NEEDS
   - Start with user need, not solution
   - Needs before wants
   - Outcomes over outputs
   Assessment: Do you start projects with user need or technology?

5. BE TRANSPARENT
   - Share information openly
   - Visible decision-making
   - Accessible reasoning
   Assessment: Can anyone understand why decisions were made?

6. REMOVE BIAS AND DUPLICATION
   - Consolidate duplicate efforts
   - Remove cognitive biases
   - Single source of truth
   Assessment: How much duplication exists in your organization?
```

### Phase II: Improve Situational Awareness

```text
AWARENESS DOCTRINE:

7. USE APPROPRIATE METHODS
   - Agile for genesis, Six Sigma for commodity
   - Match method to component evolution
   - No one-size-fits-all
   Assessment: Do you use different methods for different components?

8. UNDERSTAND WHAT IS BEING CONSIDERED
   - Clarity on scope and boundaries
   - Explicit about what's included/excluded
   - Clear problem definition
   Assessment: Is scope clearly defined before decisions?

9. THINK SMALL
   - Small, focused teams
   - Incremental delivery
   - Fail fast, learn fast
   Assessment: What's your typical team/project size?

10. FOCUS ON HIGH SITUATIONAL AWARENESS
    - Know where you are on the map
    - Understand competitive landscape
    - Recognize evolution patterns
    Assessment: Do you know your position relative to competitors?

11. USE STANDARDS WHERE APPROPRIATE
    - Adopt standards for commodity components
    - Build standards for emerging patterns
    - Avoid reinventing wheels
    Assessment: Where are you building vs. buying/standardizing?

12. MANAGE INERTIA
    - Recognize resistance to change
    - Address sources of inertia
    - Plan for transition
    Assessment: What organizational inertia are you fighting?
```

### Phase III: Improve Strategic Play

```text
STRATEGIC DOCTRINE:

13. THINK FAST, INEXPENSIVE, RESTRAINED, ELEGANT (FIRE)
    - Speed over perfection
    - Cost-effectiveness
    - Minimal viable solutions
    - Elegant simplicity
    Assessment: Is your default fast and cheap or slow and expensive?

14. EXPLOIT THE LANDSCAPE
    - Use map position for advantage
    - Leverage evolution dynamics
    - Time moves appropriately
    Assessment: Are you using position strategically?

15. BE HUMBLE
    - Acknowledge uncertainty
    - Learn from failure
    - Accept you might be wrong
    Assessment: How does your org handle being wrong?

16. MOVE FAST
    - Speed as competitive advantage
    - Reduce decision latency
    - Enable rapid iteration
    Assessment: How long from idea to production?

17. DESIGN FOR CONSTANT EVOLUTION
    - Assume everything changes
    - Build for adaptability
    - Embrace continuous improvement
    Assessment: Is your architecture ready for evolution?

18. USE A BIAS TOWARD ACTION
    - Decide and act over analyze and wait
    - Good enough decisions quickly
    - Course-correct in motion
    Assessment: Analysis paralysis or action bias?
```

### Phase IV: Lead Effectively

```text
LEADERSHIP DOCTRINE:

19. DISTRIBUTE POWER AND DECISION MAKING
    - Push decisions to edges
    - Empower teams closest to work
    - Reduce bottlenecks
    Assessment: Where are decisions made in your org?

20. PROVIDE PURPOSE, MASTERY, AUTONOMY
    - Clear purpose alignment
    - Enable skill development
    - Grant appropriate freedom
    Assessment: Do teams have purpose, mastery, autonomy?

21. SET DIRECTION BUT ALLOW FREEDOM
    - Commander's intent over detailed orders
    - What, not how
    - Align on outcomes, not activities
    Assessment: How prescriptive are your directions?

22. THINK BIG
    - Ambitious vision
    - Long-term thinking
    - Transformational goals
    Assessment: How ambitious is your vision?

23. SEEK THE BEST
    - Hire great people
    - Continuous learning
    - Excellence as standard
    Assessment: Is excellence the default expectation?

24. LISTEN TO YOUR ECOSYSTEMS
    - External awareness
    - Partner feedback
    - Community engagement
    Assessment: How connected are you to your ecosystem?
```

## Doctrine Assessment Matrix

```text
Assessment Scoring:

1 = Not practiced
2 = Occasionally practiced
3 = Regularly practiced
4 = Consistently practiced
5 = Cultural norm

PHASE I: STOP SELF-HARM
□ Know your users                    [1][2][3][4][5]
□ Use common language                [1][2][3][4][5]
□ Challenge assumptions              [1][2][3][4][5]
□ Focus on user needs                [1][2][3][4][5]
□ Be transparent                     [1][2][3][4][5]
□ Remove bias and duplication        [1][2][3][4][5]

PHASE II: SITUATIONAL AWARENESS
□ Use appropriate methods            [1][2][3][4][5]
□ Understand what's being considered [1][2][3][4][5]
□ Think small                        [1][2][3][4][5]
□ High situational awareness         [1][2][3][4][5]
□ Use standards where appropriate    [1][2][3][4][5]
□ Manage inertia                     [1][2][3][4][5]

PHASE III: STRATEGIC PLAY
□ Think FIRE                         [1][2][3][4][5]
□ Exploit the landscape              [1][2][3][4][5]
□ Be humble                          [1][2][3][4][5]
□ Move fast                          [1][2][3][4][5]
□ Design for constant evolution      [1][2][3][4][5]
□ Bias toward action                 [1][2][3][4][5]

PHASE IV: LEADERSHIP
□ Distribute power                   [1][2][3][4][5]
□ Purpose, mastery, autonomy         [1][2][3][4][5]
□ Set direction, allow freedom       [1][2][3][4][5]
□ Think big                          [1][2][3][4][5]
□ Seek the best                      [1][2][3][4][5]
□ Listen to ecosystems               [1][2][3][4][5]
```

## Doctrine Maturity Model

### Maturity Levels

| Level | Score Range | Characteristics |
|-------|-------------|-----------------|
| **1: Chaos** | 24-48 | No consistent practices, reactive |
| **2: Emerging** | 49-72 | Some awareness, inconsistent application |
| **3: Practicing** | 73-96 | Regular practice, gaps remain |
| **4: Mature** | 97-110 | Consistent practice, cultural integration |
| **5: Exemplary** | 111-120 | Cultural norm, continuous improvement |

### Phase Dependencies

```text
Doctrine Development Path:

Phase I ───► Phase II ───► Phase III ───► Phase IV
(Foundation) (Awareness)   (Strategy)     (Leadership)

Rules:
- Must achieve Phase I before Phase II is effective
- Phases build on each other
- Gaps in lower phases undermine higher phases
- Most orgs skip phases (unsuccessfully)
```

## Assessment Template

```markdown
# Doctrine Assessment: [Organization/Team]

## Assessment Date: [Date]
## Assessor: [Name/Role]

## Executive Summary

### Overall Maturity: [Level 1-5]
### Total Score: [X/120]
### Primary Gaps: [Top 3 gaps]
### Recommended Focus: [Phase to prioritize]

## Phase Scores

| Phase | Max Score | Actual | Percentage |
|-------|-----------|--------|------------|
| I: Stop Self-Harm | 30 | [X] | [%] |
| II: Situational Awareness | 30 | [X] | [%] |
| III: Strategic Play | 30 | [X] | [%] |
| IV: Leadership | 30 | [X] | [%] |
| **TOTAL** | **120** | **[X]** | **[%]** |

## Detailed Assessment

### Phase I: Stop Self-Inflicted Harm

| Doctrine | Score | Evidence | Gap Analysis |
|----------|-------|----------|--------------|
| Know your users | [1-5] | [What you observed] | [What's missing] |
| Use common language | [1-5] | [What you observed] | [What's missing] |
| Challenge assumptions | [1-5] | [What you observed] | [What's missing] |
| Focus on user needs | [1-5] | [What you observed] | [What's missing] |
| Be transparent | [1-5] | [What you observed] | [What's missing] |
| Remove bias/duplication | [1-5] | [What you observed] | [What's missing] |

[Repeat for Phases II, III, IV]

## Improvement Roadmap

### Immediate Actions (0-30 days)
1. [Action for critical gap]
2. [Action for critical gap]

### Short-term (1-3 months)
1. [Phase I improvements]
2. [Quick wins]

### Medium-term (3-6 months)
1. [Phase II development]
2. [Cultural changes]

### Long-term (6-12 months)
1. [Phase III/IV development]
2. [Organizational transformation]

## Success Metrics

| Doctrine Area | Current | Target (6mo) | Measure |
|---------------|---------|--------------|---------|
| [Area] | [Score] | [Target] | [How to measure] |

## Review Schedule
- Monthly review: [Dates]
- Quarterly assessment: [Dates]
```

## Common Doctrine Anti-Patterns

```text
PHASE I FAILURES:
- Assuming you know users without research
- Jargon-heavy communication
- "We've always done it this way"
- Building features, not solving needs

PHASE II FAILURES:
- Agile everywhere (ignoring evolution)
- Scope creep without boundaries
- Large programs and teams
- Copying competitors blindly

PHASE III FAILURES:
- Over-engineering everything
- Analysis paralysis
- Arrogant certainty
- Slow, expensive, complex defaults

PHASE IV FAILURES:
- Central command and control
- Micromanagement
- Vague direction with no freedom
- Small thinking, fear of failure
```

## Doctrine vs Strategy Integration

```text
How Doctrine Supports Strategy:

DOCTRINE (Universal)          STRATEGY (Context-Dependent)
────────────────────         ─────────────────────────────
Know your users       ───►   Who specifically to target
Use common language   ───►   Map the competitive landscape
Challenge assumptions ───►   Test strategic hypotheses
Think small           ───►   Incremental strategic moves
Move fast             ───►   Time strategic plays correctly
Manage inertia        ───►   Address specific resistance

Doctrine enables strategy execution.
Poor doctrine undermines even brilliant strategy.
```

## Workflow

When assessing doctrine:

1. **Gather Evidence**: Interviews, observations, artifacts
2. **Score Each Doctrine**: Use 1-5 scale with evidence
3. **Calculate Phase Scores**: Sum and percentage
4. **Identify Gaps**: Lowest scores, phase imbalances
5. **Prioritize by Phase**: Fix Phase I before Phase II
6. **Create Roadmap**: Time-bound improvement plan
7. **Define Metrics**: How to measure progress
8. **Schedule Reviews**: Regular reassessment

## References

For detailed guidance:

---

**Last Updated:** 2025-12-26
