---
name: evolution-analysis
description: Analyze component evolution and movement patterns
allowed-tools: Read, Glob, Grep, Write, Edit
---

# Evolution Analysis Skill

Analyze component evolution stages, movement patterns, and climatic forces affecting strategic positioning.

## When to Use This Skill

Use this skill when:

- **Evolution Analysis tasks** - Working on analyze component evolution and movement patterns
- **Planning or design** - Need guidance on Evolution Analysis approaches
- **Best practices** - Want to follow established patterns and standards

## MANDATORY: Documentation-First Approach

Before analyzing evolution:

1. **Invoke `docs-management` skill** for evolution patterns
2. **Verify evolution characteristics** via MCP servers (perplexity)
3. **Base guidance on Wardley's climatic patterns**

## Evolution Framework

```text
Evolution Stages and Characteristics:

Stage I: GENESIS
├── Poorly understood
├── Uncertain
├── Unpredictable
├── Constantly changing
├── Exciting/wonder
├── Low failure tolerance
└── Requires exploration

Stage II: CUSTOM-BUILT
├── Emerging understanding
├── Growing market
├── Increasing stability
├── Divergent approaches
├── Best practice emerging
└── Requires differentiation

Stage III: PRODUCT (+RENTAL)
├── Well understood
├── Feature competition
├── Stable architectures
├── Defined best practices
├── Market consolidation
└── Requires market fit

Stage IV: COMMODITY (+UTILITY)
├── Ubiquitous
├── Standardized
├── Cost-focused
├── Operational excellence
├── Highly predictable
└── Requires efficiency
```

## Evolution Indicators

### Stage Assessment Checklist

```text
Genesis Indicators:
□ No established market
□ Uncertain about what's possible
□ High experimentation
□ Frequent pivots
□ Experts disagree on approach
□ No clear pricing model
□ Failure is expected

Custom Indicators:
□ Growing understanding
□ Talent is scarce
□ Multiple competing approaches
□ Early adopters engaged
□ Starting to see patterns
□ Custom development required
□ Premium pricing accepted

Product Indicators:
□ Clear market exists
□ Feature comparison possible
□ Documentation exists
□ Training available
□ Established vendors
□ Predictable delivery
□ Competitive pricing

Commodity Indicators:
□ Ubiquitous availability
□ Standard interfaces
□ Utility pricing
□ Focus on cost reduction
□ Scale operations
□ Interchangeable suppliers
□ SLA-driven decisions
```

## Climatic Patterns

### Patterns That Affect Evolution

```text
Climatic Pattern Categories:

1. EVERYTHING EVOLVES
   - No component remains static
   - Evolution driven by competition
   - Supply and demand drives movement

2. CHARACTERISTICS CHANGE
   - What matters changes with evolution
   - Early: Functionality matters
   - Late: Price and reliability matter

3. NO ONE SIZE FITS ALL
   - Different methods for different stages
   - Agile for genesis, Six Sigma for commodity
   - Pioneer/Settler/Town Planner model

4. EFFICIENCY ENABLES INNOVATION
   - Commoditized components enable new genesis
   - Higher-order systems emerge from utilities
   - Cloud enabled SaaS explosion

5. HIGHER ORDER SYSTEMS CREATE NEW SOURCES OF WORTH
   - Combinations create new value
   - API economy examples
   - Platform plays

6. PAST SUCCESS BREEDS INERTIA
   - Success creates resistance to change
   - Organizational and individual inertia
   - Requires active management
```

### Weak Signals of Evolution

```text
Signs a Component is About to Evolve:

Genesis → Custom:
- Successful experiments being replicated
- Hiring for specific expertise
- Conference talks appearing
- Blog posts explaining "how we did X"

Custom → Product:
- Common patterns documented
- Books being written
- Training courses available
- Vendors appearing
- Open source implementations

Product → Commodity:
- Feature wars declining
- Price competition increasing
- API standardization
- Utility pricing models
- Cloud/SaaS offerings
```

## Inertia Analysis

### Types of Inertia

| Inertia Type | Description | Signs |
|--------------|-------------|-------|
| **Success** | "It worked before" | Resistance to change successful patterns |
| **Capital** | Sunk cost | Large investments in existing approach |
| **Political** | Power structures | Empires built on current technology |
| **Skills** | Team capabilities | Teams expert in current approach |
| **Supplier** | Vendor relationships | Long-term contracts, relationships |
| **Consumer** | User expectations | Users expect current approach |

### Overcoming Inertia

```text
Inertia Management Strategies:

1. ACKNOWLEDGE
   - Recognize inertia exists
   - Don't fight it directly
   - Understand the source

2. CREATE ALTERNATIVES
   - Build parallel capability
   - Don't force immediate switch
   - Let new approach prove itself

3. MANAGE TRANSITION
   - Gradual migration
   - Clear sunset timelines
   - Training and support

4. ADDRESS ROOT CAUSES
   - Skill development
   - Relationship management
   - Political navigation
```

## Movement Analysis

### Predicting Movement

```text
Movement Prediction Framework:

COMPETITIVE PRESSURE
├── High competition → Faster evolution
├── Low margins → Commodity imminent
└── Feature convergence → Product → Commodity

TECHNOLOGY SHIFTS
├── New enabling technology
├── Cost reduction breakthroughs
└── Standardization efforts

MARKET DYNAMICS
├── User demand patterns
├── Regulatory changes
└── Economic pressures

ECOSYSTEM EFFECTS
├── Adjacent commoditization
├── Platform availability
└── Developer adoption
```

### Movement Speed

| Factor | Faster Evolution | Slower Evolution |
|--------|------------------|------------------|
| Competition | High | Low (monopoly) |
| Standardization | Industry efforts | Proprietary lock-in |
| Capital | VC investment | Limited funding |
| Regulation | Minimal | Heavy regulation |
| Network effects | Strong | Weak |

## Analysis Template

```markdown
# Evolution Analysis: [Component/System]

## Current Position Assessment

### Component Inventory

| Component | Current Stage | Evidence |
|-----------|---------------|----------|
| [Name] | Genesis/Custom/Product/Commodity | [Indicators observed] |

### Evolution Evidence

**Genesis Stage Components:**
- [Component]: [Why it's in genesis]

**Evolving Components:**
- [Component]: Moving from [stage] to [stage]
- Evidence: [Signs of movement]

## Climatic Patterns Active

### Relevant Patterns
1. [Pattern]: [How it affects this context]
2. [Pattern]: [How it affects this context]

## Inertia Assessment

### Sources of Inertia

| Component | Inertia Type | Strength | Mitigation |
|-----------|--------------|----------|------------|
| [Name] | Success/Capital/Political | High/Med/Low | [Strategy] |

## Movement Forecast

### 6-Month Horizon
- [Component] likely to evolve to [stage]
- Trigger: [What will cause movement]

### 18-Month Horizon
- [Component] likely to evolve to [stage]
- Industry trend: [Supporting evidence]

## Strategic Implications

### Opportunities
- [Opportunity from evolution]

### Threats
- [Threat from evolution]

### Recommended Actions
1. [Action based on evolution analysis]
2. [Action based on inertia management]
```

## Evolution Timeline Patterns

```text
Typical Evolution Timelines:

FAST (2-5 years through all stages):
- Consumer internet services
- Mobile apps
- Cloud features
- AI/ML capabilities (currently)

MEDIUM (5-15 years):
- Enterprise software categories
- Development practices
- Infrastructure patterns

SLOW (15-30+ years):
- Physical infrastructure
- Regulated industries
- Deep technical systems

Acceleration Factors:
- Open source adoption
- Cloud availability
- Developer community
- VC investment
- API-first design
```

## Workflow

When analyzing evolution:

1. **Inventory Components**: List all relevant components
2. **Assess Current Stage**: Use indicators checklist
3. **Identify Movement**: Look for evolution signals
4. **Analyze Inertia**: Understand resistance sources
5. **Predict Timing**: Estimate movement speed
6. **Strategic Implications**: What does this mean for decisions?

## References

For detailed guidance:

---

**Last Updated:** 2025-12-26
