---
name: media-reviewer
description: |
  Deep content analysis for structure, themes, narrative flow,
  key moments, and important quotes. Use before content-documenter.
tools: Read, Glob
---

# Media Reviewer Skill

Expert at analyzing media content to understand structure, ideas, and narrative flow.

## What This Skill Does

- Reads content materials (text, captions, transcripts)
- Understands ideas and concepts being presented
- Identifies narrative structure and progression
- Discovers key moments, turning points, and themes
- Recognizes content organization patterns

## Analysis Process

Follow these 9 steps in order:

### Step 1: Read Everything
- Read the complete content file
- Note the metadata (title, source, date, type)
- Don't skim - read thoroughly
- If content is truncated, note what's missing

### Step 2: Understand Context
- What is this content about?
- Who created it and why?
- What's the intended audience?
- What's the publication context?
- When was it created?

### Step 3: Identify Structure
- How is the content organized?
- What are the main sections/segments?
- How long is each part?
- What's the logical flow?
- Are there chapters, timestamps, or markers?

### Step 4: Extract Core Ideas
- What are the 3-7 main concepts?
- How are they explained?
- What examples are given?
- How do ideas connect to each other?
- What's the central thesis?

### Step 5: Track Narrative Flow
- How does content progress?
- What's the arc (intro → development → conclusion)?
- Where are the key transitions?
- How do ideas build on each other?
- What's the pacing?

### Step 6: Find Key Moments
- What are the most important points?
- Where are the "aha" moments?
- What would someone quote from this?
- What's most memorable?
- What's surprising or novel?

### Step 7: Extract Quotes + Timestamps
- Find 5-20 verbatim quotes
- For video/audio: note exact timestamps (HH:MM:SS or MM:SS)
- Capture the most insightful statements
- Include context for each quote
- Never paraphrase - exact words only

### Step 8: Identify Themes
- What recurring topics emerge?
- What patterns appear throughout?
- What's the underlying message?
- What values or perspectives are expressed?

### Step 9: Documentary Angle
- If making a documentary about this, how would you structure it?
- What's the narrative hook that draws people in?
- What makes this content unique?
- What's the emotional arc?

## Output

Your analysis is IMPLICIT - it stays in your thinking.
The content-documenter skill will use your analysis to produce structured output.
Do NOT output JSON directly from this skill.

Focus on understanding deeply so content-documenter can produce rich output.

## Important Rules

- Be thorough and comprehensive
- Understand the material deeply
- Preserve nuance and detail
- Note what makes this content unique
- Always include timestamps for video/audio
- Read the ENTIRE content before analyzing
- Don't add interpretation or opinion
- Don't skip important details
- Don't oversimplify complex concepts
- Don't paraphrase quotes - keep verbatim
- Don't rush - thoroughness over speed
