---
name: mcp-client
description: Universal MCP client for connecting to any MCP server. Bundle scripts/mcp-client.py with your skill to enable dynamic tool discovery and execution without context bloat. Use when creating skills that need MCP server access.
allowed-tools: Bash(python:*) Read Write
---

# MCP Client

A universal client for connecting to MCP (Model Context Protocol) servers. This skill provides a reusable script that any other skill can bundle to access MCP servers dynamically.

## Why Use This?

Instead of loading all MCP tool definitions into context (which bloats tokens), this pattern:

1. **Discovers tools on-demand** - only load what you need
2. **Caches schemas** - emit to `references/` for progressive disclosure
3. **Processes data locally** - results flow through script, not context
4. **Saves 80-98% tokens** - per Anthropic's code execution research

## Quick Start

### 1. Copy the script to your skill

```bash
cp scripts/mcp-client.py /path/to/your-skill/scripts/
```

### 2. Discover available tools

```bash
# HTTP transport
python scripts/mcp-client.py list --url http://localhost:8080

# stdio transport (local server)
python scripts/mcp-client.py list --stdio "npx -y @modelcontextprotocol/server-github"
```

### 3. Cache tool schemas (one-time setup)

```bash
python scripts/mcp-client.py emit --url http://localhost:8080 > references/tools.md
```

### 4. Call tools at runtime

```bash
python scripts/mcp-client.py call \
  --url http://localhost:8080 \
  --tool create_issue \
  --params '{"title": "Bug", "body": "Description"}'
```

## Commands

| Command | Description |
|---------|-------------|
| `list` | List available tools (use `-v` for full details) |
| `call` | Call a tool with parameters |
| `emit` | Generate documentation (`--format markdown\|json`) |
| `resources` | List available resources |
| `prompts` | List available prompts |

## Transport Options

| Option | Description |
|--------|-------------|
| `--url`, `-u` | HTTP URL of MCP server |
| `--stdio`, `-s` | Command to start stdio MCP server |
| `--header`, `-H` | HTTP header (can repeat) |

## Examples

### Connect to GitHub MCP server

```bash
# Using stdio (local)
python scripts/mcp-client.py list \
  --stdio "npx -y @modelcontextprotocol/server-github"

# Using HTTP (remote)
python scripts/mcp-client.py list \
  --url https://mcp.example.com/github \
  --header "Authorization: Bearer $TOKEN"
```

### Call a tool with complex parameters

```bash
python scripts/mcp-client.py call \
  --url http://localhost:8080 \
  --tool search_issues \
  --params '{
    "query": "is:open label:bug",
    "limit": 10,
    "sort": "updated"
  }'
```

### Emit cached documentation

```bash
# Markdown (for references/)
python scripts/mcp-client.py emit --url http://localhost:8080 --format markdown

# JSON (for programmatic use)
python scripts/mcp-client.py emit --url http://localhost:8080 --format json
```

## Creating a Domain Skill with MCP

Here's how to create a new skill that uses an MCP server:

### 1. Create skill structure

```
my-domain-skill/
├── SKILL.md
├── scripts/
│   └── mcp-client.py    # Copy from this skill
└── references/
    └── tools.md         # Generated by emit
```

### 2. Write your SKILL.md

```yaml
---
name: my-domain-skill
description: Does X using the Y MCP server
allowed-tools: Bash(python:*) Read
---

# My Domain Skill

## Setup
Ensure MCP server is running at http://localhost:8080

## Available Tools
See [references/tools.md](references/tools.md)

## Workflows

### Do something useful
1. List available items: `python scripts/mcp-client.py call --url ... --tool list_items`
2. Process results...
```

### 3. Generate cached tool documentation

```bash
cd my-domain-skill
python scripts/mcp-client.py emit --url http://localhost:8080 > references/tools.md
```

Now agents can read `references/tools.md` on-demand instead of loading all tool definitions upfront.

## Architecture

```
┌─────────────────────────────────────────────────────────────┐
│ Agent reads SKILL.md (~100 tokens)                          │
│ Agent reads references/tools.md on-demand (if needed)       │
│ Agent runs: python scripts/mcp-client.py call ...           │
│ → Data flows through script, NOT context window             │
└─────────────────────────────────────────────────────────────┘
                              ↓
              ┌───────────────────────────────┐
              │   scripts/mcp-client.py       │
              │   ────────────────────────    │
              │   HTTP or stdio transport     │
              │   JSON-RPC over MCP protocol  │
              └───────────────────────────────┘
                              ↓
              ┌───────────────────────────────┐
              │      Any MCP Server           │
              │   (GitHub, Slack, custom...)  │
              └───────────────────────────────┘
```

## Reference

See [references/mcp-protocol.md](references/mcp-protocol.md) for protocol details.
