---
name: error-tracking
description: Set up error tracking with actionable context. Use when configuring error capture or error boundaries.
triggers:
  - "error tracking"
  - "capture errors"
  - "error boundaries"
priority: 1
---

# Error Tracking

Capture errors with the context needed to debug them.

## Core Principle

An error without context is useless. Every error should include:

| Context | Why | Example |
|---------|-----|---------|
| `route` | Where it happened | "/checkout" |
| `job_name` | What user was doing | "checkout" |
| `job_step` | Where in the flow | "payment" |
| `user_segment` | Who's affected | "premium" |
| `app_version` | Release correlation | "1.2.3" |

## Error Types to Capture

| Type | Capture Method |
|------|----------------|
| Unhandled exceptions | `window.onerror`, SDK auto-capture |
| Promise rejections | `window.onunhandledrejection` |
| Component errors | Error boundaries |
| Async/await errors | try/catch with context |
| API errors | Fetch/axios interceptors |

## What NOT to Include

| Don't | Why |
|-------|-----|
| Passwords | Security |
| Email/phone | PII |
| Full request bodies | PII, size limits |
| Entire app state | Unbounded |
| Localized messages | Breaks grouping |

## Implementation

See `templates/error-boundary.tsx` for React error boundary with telemetry.

Use Read tool to load template when generating implementation.

## Anti-Patterns

See `references/anti-patterns.md` for common error tracking mistakes.

## Related

- `skills/source-map-setup` - Readable stack traces
- `skills/api-tracing` - API error correlation
- `references/frameworks/*.md` - Framework-specific error handling
