---
name: session-replay
description: Set up session replay for visual debugging. Use when implementing DOM recording with privacy controls.
triggers:
  - "session replay"
  - "record user sessions"
  - "visual debugging"
priority: 3
---

# Session Replay

Capture visual recordings of user sessions for debugging.

## When to Use

- Reproducing hard-to-debug issues
- Understanding user confusion
- QA and support investigations
- Validating error context

## Privacy Requirements (Must Do)

Mask by default:
- All text input fields
- Passwords and sensitive data
- Financial information
- Personal identifiers
- User photos/documents
- Chat messages

## Performance Budget

| Resource | Limit |
|----------|-------|
| CPU | <3% additional |
| Memory | <10MB additional |
| Network | Batch uploads, compress |
| Bundle | Lazy load SDK |

## Best Practices

| Do | Don't |
|----|-------|
| Lazy load replay SDK | Include in main bundle |
| Mask all inputs by default | Allow recording of inputs |
| Sample sessions (10-20%) | Record 100% |
| Focus on error sessions | Record everything |
| Test privacy masking | Assume it works |

## Sampling Strategy

```
replaysSessionSampleRate: 0.1   // 10% of sessions
replaysOnErrorSampleRate: 1.0   // 100% of error sessions
```

## Implementation

Load vendor-specific configuration from `references/platforms/*.md` when generating code.

| Vendor | Config Reference |
|--------|------------------|
| Sentry | `references/platforms/sentry.md` |
| Datadog | `references/platforms/datadog.md` |
| LogRocket | `references/platforms/logrocket.md` |
| FullStory | `references/platforms/fullstory.md` |

## Related

- `skills/error-tracking` - Correlating errors with replays
- `skills/user-journey-tracking` - Session context
