# Tech Talk Story Circle Framework

The Story Circle is an eight-step framework adapted from Dan Harmon's storytelling technique. It structures tech talks to create engaging narratives.

## The Eight Steps

### 1. Introduction (You)
**Top half - Order**

Introduce yourself and the current status quo of your project.

- Set the scene with the existing workflow or technology stack
- Establish the baseline before disruption
- Make the audience understand the familiar ground

### 2. Problem Statement (Need)
**Top half - Order**

Identify and explain the problem you're trying to solve.

- Clearly articulate what's not working
- Help the audience feel the pain point
- Create the motivation for change

### 3. Exploration (Go)
**Crossing to bottom half - Chaos**

Describe the steps taken to address the problem.

- What did you try?
- What worked?
- What didn't work?
- Show the journey into the unknown

### 4. Experimentation (Search)
**Bottom half - Chaos**

Detail the process of digging into the actual problem.

- What did you learn?
- What experiments did you run?
- What discoveries did you make?
- Share the messy middle of problem-solving

### 5. Solution (Find)
**Bottom half - Chaos**

Explain how you found the solution or made progress.

- Present the breakthrough moment
- Show what finally clicked
- Explain the technical approach that worked

### 6. Challenges (Take)
**Bottom half - Chaos**

Discuss the actual implementation of the project.

- Emphasize the disruption to the status quo
- Share the difficulties and tradeoffs
- Be honest about the cost of change

### 7. Apply Knowledge (Return)
**Crossing to top half - Order**

Describe the results and how the solution was integrated.

- Show how you brought the solution back to your project
- Demonstrate the practical application
- Return to the familiar with new tools

### 8. Results & Insights (Change)
**Top half - Order**

Conclude with lessons learned and how things changed.

- Share metrics or outcomes
- Explain what changed in your workflow or perspective
- Leave the audience with actionable insights

## Structure Notes

**Top half (steps 1, 2, 7, 8)**: Represents established practices and order
**Bottom half (steps 3, 4, 5, 6)**: Represents disruption and experimentation

The character (you) starts in the top half, enters the bottom half to experiment and disrupt, then returns to the top half with new knowledge, changing the status quo.

## Example

From "Unleashing the TypeScript Compiler":

1. Status quo of a TypeScript/React project using Material-UI
2. Challenges faced with the project
3. Solutions tried to work around issues
4. Exploring the TypeScript compiler and codemods
5. Using new knowledge to solve problems
6. Challenges implementing the solution for every scenario
7. Applying knowledge to the project
8. Results and changed team perspective on codemods
