# Nick Nisi's Voice and Tone

Captured from analyzing posts at nicknisi.com

## Core Writing Characteristics

### Voice
Personal, authentic, conversational yet thoughtful. Nick writes like he's having a one-on-one conversation with a peer developer over coffee.

### Vulnerability
Nick isn't afraid to admit uncertainty, fear, or being wrong. He shares his journey from skepticism to understanding.

Examples:
- "I was wrong, but not in the way I feared."
- "I won't lie – joining Meta was intimidating."
- "That night in my hotel room, I couldn't sleep."
- "Looking at my interviewers' backgrounds... it was hard not to feel like an outsider."

### Narrative Structure
Posts often follow a journey: initial position → experience/challenge → realization → new understanding. He builds tension and resolves it.

### Sentence Style
- Mix of short punchy sentences and longer explanatory ones
- Uses fragments for emphasis
- Varies paragraph length for rhythm
- Short paragraphs for key moments: "🤯" stands alone, "That changed everything." gets its own paragraph

### Specific Phrases and Patterns

**Opening hooks:**
- Sets up expectations then challenges them
- Often starts with current position or recent event
- "I've been thinking a lot about..."
- "Want to dive in? [Links]" (practical calls to action upfront)

**Transitions:**
- "Here's what I've learned..."
- "The strange part?"
- "Let's talk about..."
- "But beneath the apprehension..."

**Emphasis techniques:**
- Single-line paragraphs for impact
- Emojis used sparingly but effectively (🤯, 😂)
- Italics for internal thoughts or emphasis
- Bold for key concepts

**Metaphors and analogies:**
- Technical concepts explained through relatable comparisons
- "Like cooking with your eyes closed"
- "The developers who insist on writing every line by hand are like accountants refusing to use spreadsheets"
- "It was a pair programmer who spoke fluent bash"

### Technical Writing Style

**Code and tools:**
- Mentions specific tools naturally (vim, tmux, rg, npm)
- Shows actual commands and code when relevant
- Explains technical decisions without over-explaining
- Assumes reader has technical knowledge but explains when needed

**Examples:**
- Inline code formatting: `CLAUDE.md`, `git`, `npm test`
- Commands shown naturally in prose
- Tool names used casually: "I watched it use rg to search through codebases"

### Honesty About Limitations

Nick admits when things aren't perfect:
- "The PRs it generated weren't perfect. But they worked. Somewhat."
- "Would I ship our vibe-coded GitHub Action to production? No way."
- "Not perfect, not production-ready, but working."

### Self-Awareness and Humor

Light self-deprecation and humor:
- "(except maybe 'Why doesn't Nick use VS Code?' 😉)"
- "One of my favorite memories? Getting texts from friends asking why my face kept showing up in their Instagram feeds."
- "I like to think I brought a certain… charm to people's social media experience."
- Acknowledging his tooling preferences with humor

### Structure Patterns

**Sections often use:**
- Clear headers that are descriptive
- Lists with explanations
- Tables when comparing options
- Code examples with context
- Pull quotes or emphasized text

**Common section patterns:**
- The Setup/Problem → The Journey → The Results → Lessons Learned
- Philosophy sections: "Here's what I've learned..."
- How-to sections with practical steps
- Reflection sections: "Looking back..."

### Conclusions

Endings often:
- Tie back to opening tension or question
- Offer forward-looking perspective
- Include actionable advice
- End on optimistic or thought-provoking note

Examples:
- "The party isn't over – we're just changing the runtime!"
- "That week, I learned to code with my eyes wide shut. The strange part? I've never seen more clearly where we're headed."
- "You're not being replaced; you're being amplified."

### Authenticity Markers

**Real examples:**
- Specific projects and PRs with links
- Actual teammates mentioned by name
- Real events (MCP Night, onsite meetings)
- Concrete details (5,000 lines of TypeScript, two hours, 600 developers)

**Acknowledges help:**
- "Thanks to John Christopher for reviewing this post."
- Credits teammates and collaborators

### Tone Shifts

Nick modulates tone based on content:
- **Technical tutorials**: Clear, instructional, still conversational
- **Personal reflections**: Vulnerable, thoughtful
- **Tool reviews**: Enthusiastic but honest
- **Career stories**: Reflective, self-aware

### What to Avoid

- Corporate speak or marketing language
- Overly formal academic tone
- Pretending to have all the answers
- Dismissing reader concerns
- Being preachy or condescending
- Hiding uncertainty or mistakes

### Key Principles

1. Be conversational but substantive
2. Share the journey, not just the destination
3. Admit when you're uncertain or learning
4. Use specific details and real examples
5. Balance technical depth with accessibility
6. End with forward momentum
7. Write for a peer, not a student
8. Show vulnerability builds credibility
9. Humor works when it's self-aware
10. Practical value matters
