
## Alerte

L’alerte est un élément d’indication poussé par l’interface pour relayer une information à l’usager.


- [Présentation](../index.md)
- [Démo](../demo/index.md)
- [Design](../design/index.md)
- [Code](../code/index.md)
- Accessibilité


Le composant **Alerte** est conçu pour être accessible et respecter les critères du RGAA. Voici les points clés à prendre en compte pour en garantir l’accessibilité.

### Interactions clavier

Aucune interaction au clavier spécifique au composant.

### Règles d’accessibilité

#### Contenu de l’alerte

- Le niveau de titre dépend du contexte de la page et ne sera pas toujours un `<h3>`.
- Le type d’alerte (info, error, success, warning) doit être indiqué textuellement dans le contenu de l'alerte par les termes : «&nbsp;information&nbsp;», «&nbsp;erreur&nbsp;», «&nbsp;succès&nbsp;», ou «&nbsp;attention&nbsp;».

#### Alertes avec bouton de fermeture

- Les alertes refermables ont un bouton de fermeture avec un intitulé explicite («&nbsp;Masquer le message&nbsp;»).
- À la fermeture de l’alerte, le focus doit être repositionné à un endroit pertinent pour l’utilisateur

#### Alertes ajoutées dynamiquement

Une alerte ajoutée après le chargement de la page doit être perçue par tous les utilisateurs.

Pour les alertes simples, ajouter sur le conteneur de l’alerte&nbsp;:
- un `role="alert"` pour les messages d’erreur ou les avertissements
- un `role="status"` pour les messages de succès ou d’information.

> [!WARNING]
> Ne pas faire disparaître l’alerte sans action de l’utilisateur. Les alertes temporaires (<span lang="en">toast</span>) posent d’importants problèmes d’accessibilité et d’utilisabilité.

### Restitution par les lecteurs d’écran

La restitution des rôles `alert` et `status` par les lecteurs d’écran varie selon les implémentations.

Le `role="alert"` est toujours correctement restitué par tous les lecteurs d’écran, peu importe la méthode d’implémentation, contrairement au `role="status"`.

En cas de problème de restitution avec le `role="status"`, il peut également être utilisé sur les messages d’information ou de succès.

### Critères RGAA applicables

- **Couleurs**&nbsp;: 3.2, 3.3
- **Scripts&nbsp;:** 7.1, 7.3, 7.5
- **Éléments obligatoires&nbsp;:** 8.9
- **Structuration&nbsp;:** 9,1
- **Présentation de l’information&nbsp;:** 10.1, 10.2, 10.3, 10.4, 10.5, 10.7, 10.11, 10.12
- **Navigation&nbsp;:** 12.8, 12.9
- **Consultation&nbsp;:** 13.9, 13.11

