
## Fil d’Ariane

Le fil d’Ariane est un système de navigation secondaire qui permet à l’usager de se situer sur le site qu’il consulte.

Le fil d’Ariane est un système de navigation secondaire qui permet à l’usager de se situer sur le site qu’il consulte.


- [Présentation](../index.md)
- [Démo](../demo/index.md)
- [Design](../design/index.md)
- [Code](../code/index.md)
- Accessibilité


Le composant **Fil d’Ariane** est conçu pour être accessible et respecter les critères du RGAA. Voici les points clés à prendre en compte pour en garantir l’accessibilité.

### Interactions clavier

Aucune interaction au clavier spécifique au composant.

### Règles d’accessibilité

> [!NOTE]
> Le fil d’Ariane n’est pas obligatoire dans le cadre du respect du RGAA. Il s’agit d’un critère d’accessibilité de niveau AAA de WCAG.
>
> Son usage est néanmoins fortement recommandé pour aider les personnes avec un handicap cognitif notamment à mieux se repérer sur le site.

#### Structuration

- Le fil d’Ariane est un système de navigation secondaire. Il doit être structuré dans un élément `nav role="navigation"`.
- L’attribut `aria-label="vous êtes ici :"` est utilisé pour nommer et donner un contexte explicite à la navigation.
- Le fil d’Ariane doit être placé en dehors du contenu principal (`main`) afin de permettre au lien d’accès au d’éviter tous les liens de navigation.
- Les éléments du fil d’Ariane sont structurés dans une liste numérotée avec les éléments `ol` et `li `.

En version mobile, l’affichage direct du fil d’Ariane est remplacé par un bouton «&nbsp;Voir le fil d’Ariane&nbsp;». À l’activation du bouton, le bouton disparaît et le focus est replacé sur le premier élément du fil d’Ariane.

**Il est obligatoire de conserver le même emplacement pour le fil d’Ariane au sein d’un ensemble de pages.**

##### Identification de la page courante

- La page courante n’est pas structurée dans un lien et n’est pas soulignée.
- Elle est en plus identifiée explicitement avec un attribut `aria-current="page"` pour les personnes aveugles.

### Contrastes de couleurs

Le composant Fil d’Ariane est suffisamment contrasté en thème clair et en thème sombre.

:::fr-table[Contrastes des textes — composant Fil d’Ariane]{valign=top multiline=true caption=false}
| Élément |  Thème clair | Thème sombre |
|------|-----|-----|
|**lien / bouton**| 5,74:1 | 5,82:1 |
|**page courante**| 11,37:1| 11,5:1 |


### Critères RGAA applicables

- **Couleurs** : 3.1, 3.2
- **Liens** : 6.1, 6.2
- **Scripts** : 7.1, 7.3
- **Structuration** : 9.2, 9.3
- **Présentation de l’information** : 10.1, 10.2, 10.3,10.4, 10.5, 10.7, 10.8, 10.11, 10.12
- **Navigation** : 12.2, 12.6, 12.8, 12.9
- **Consultation&nbsp;:** 13.9, 13.11

