# Pied de page

> **Informations complémentaires en bas de page**

## Navigation

- [Accessibilité](./accessibilite.md) - Guide d'accessibilité RGAA
- [Code](./code.md) - Documentation technique et API
- [Design](./design.md) - Spécifications design
- [Exemples](./examples/) - Exemples de code HTML

## Pied de page

Le pied de page est un élément de navigation secondaire mis à disposition de l’usager pour qu’il poursuive son parcours. Il propose également des éléments d’information complémentaires.


- Présentation
- [Démo](./demo/index.md)
- [Design](./design/index.md)
- [Code](./code/index.md)
- [Accessibilité](./accessibility/index.md)



### Quand utiliser ce composant ?

**Intégrer le pied de page sur l’ensemble des sites de la sphère gouvernementale**. Au sein d’un site, le pied de page doit être affiché en bas de chacune des pages.

### Comment utiliser ce composant ?

- **Proposer a minima le pied de page simple** (bloc Marque, liens obligatoires et mention de la licence).
- **Utiliser le pied de page complet** (avec listes de liens) pour les sites profonds nécessitant de réintégrer des liens en rebond de la navigation.
- **Classer les listes de liens** lorsque vous le pouvez, pour faciliter la lecture par l’usager. Il est possible d’inclure jusqu'à 6 colonnes de liens et nous recommandons de ne pas dépasser des listes de 8 liens.
- **Penser le pied de page comme un élément complémentaire à la navigation principale**. Il ne doit pas être le miroir de cette dernière. Un travail de conception particulier est de fait nécessaire pour proposer des contenus adaptés, qui répondent par exemple aux questions restantes de l’usager.

### Règles éditoriales

- **Utiliser le texte de présentation pour donner des informations complémentaires** sur le service (description) ou l’organisation (contact, adresse etc.).
- **Proposer des libellés de liens clairs et concis** afin que l’usager comprenne facilement les pages auxquelles il peut accéder.
