
## En-tête

L’en-tête est un élément de navigation permettant aux usagers d’identifier sur quel site ils se trouvent et de leur donner un accès simplifié au moteur de recherche et à certaines pages ou fonctionnalités clés du site.


- [Présentation](../index.md)
- [Démo](../demo/index.md)
- Design
- [Code](../code/index.md)
- [Accessibilité](../accessibility/index.md)



![Anatomie de l'en-tête](../_asset/anatomy/anatomy-1.png)








### Variations

**En-tête en berne**


Lors des périodes de deuil national, il est possible d’utiliser la version en berne du header. La Marianne s’affichera alors dans sa version en berne.

**Responsive**


En version mobile, l’en-tête se compose d’une zone haute intégrant les éléments obligatoires liés au bloc marque. Le bloc marque suit les mêmes règle de composition que pour le desktop et doit respecter [la charte de marque de l'État](https://www.gouvernement.fr/marque-Etat).

Il est complété d’une potentielle zone basse comprenant :

- Le nom du site - si présent,
- Le pictogramme “loupe” pour accéder à la recherche - si présente.

Il permet l’affichage de la barre de recherche dans un “overlay” dédié.

- Le pictogramme “burger” pour accéder au menu principal - si accès rapides et/ou navigation principale présents ([voir en détail la navigation mobile](../../../../navigation/_part/doc/index.md)).

Il permet l’affichage du menu principal dans “overlay’ dédié.

### Tailles

La largeur de l’en-tête est de taille fixe et prend les 12 colonnes disponibles de la grille.

La hauteur minimale de l’en-tête est également de taille fixe, puis celle-ci s’agrandit en fonction de la hauteur du bloc marque.

### États

L’en-tête n’est sujet à aucun changement d’état.

### Personnalisation

L’en-tête n’est pas personnalisable.

Toutefois, certains éléments sont optionnels - voir [la structure du composant](#en-tête).



![](./assets/_asset/custom/do-1.png)

Considérer que chaque élément de l’en-tête à une place définie et conserver leur design en l’état, sans personnalisation.





![](./assets/_asset/custom/dont-1.png)

Ne pas modifier le positionnement des éléments de l’en-tête.





![](./assets/_asset/custom/dont-2.png)

Ne pas modifier les tailles et types de typographie du nom du site et de la baseline.





![](./assets/_asset/custom/dont-3.png)

Ne pas personnaliser le type de bouton des accès rapides.





![](./assets/_asset/custom/dont-4.png)

Ne pas proposer de contour aux boutons tertiaires, hormis s’il s’agit de celui positionner le plus à droite.


