# En-tête

> **Identification du site et accès rapides**

## Navigation

- [Accessibilité](./accessibilite.md) - Guide d'accessibilité RGAA
- [Code](./code.md) - Documentation technique et API
- [Design](./design.md) - Spécifications design
- [Exemples](./examples/) - Exemples de code HTML

## En-tête

L’en-tête est un élément de navigation permettant aux usagers d’identifier sur quel site ils se trouvent et de leur donner un accès simplifié au moteur de recherche et à certaines pages ou fonctionnalités clés du site.


- Présentation
- [Démo](demo/index.md)
- [Design](design/index.md)
- [Code](code/index.md)
- [Accessibilité](accessibility/index.md)



### Quand utiliser ce composant ?

**Intégrer l’en-tête sur l’ensemble des sites de la sphère gouvernementale**. Au sein d’un site, l’en-tête doit être affiché en haut de chacune des pages.

### Comment utiliser ce composant ?

- **Utiliser l’en-tête simple** (bloc Marque, nom du site et baseline) pour les sites n’ayant pas l’utilité d’un moteur de recherche, ni d’accès rapides.
- **Utiliser l’en-tête avec accès rapides** pour les sites souhaitant mettre en avant certaines pages ou fonctionnalités clés, par exemple la connexion à un espace sécurisé.
- **Utiliser l’en-tête avec la recherche** pour les sites souhaitant rendre facilement accessible leur moteur de recherche.
- **Utiliser la version complète** (accès rapides et moteur de recherche) pour les sites souhaitant combinés les deux fonctionnalités.
- **Ajouter un badge comportant la mention "Bêta" à l’en-tête** pour notifier l’usager que le site ou l’applicatif n’est pas en version stable.
- **Compléter l’en-tête d’une navigation principale** si nécessaire. L’en-tête peut tout à fait vivre seul, sans système de navigation principale, par exemple dans le cas de one-pager ou de site outil. [La navigation principale](../../../navigation/_part/doc/index.md) est un composant dissocié de l’en-tête.
- **Intégrer un lien vers la page d’accueil du site au sein de l’en-tête**. Son emplacement peut varier selon les éléments présents dans l’en-tête.

### Règles éditoriales

- **Proposer des libellés d’accès rapides clairs et concis** afin que l’usager comprenne facilement les pages ou fonctionnalités auxquelles il peut accéder.
- **Eviter de proposer un logo opérateur seul** et préférer l’accompagner du nom de site, voire d’une baseline, pour apporter du contexte à l’usager.
