
## Navigation principale

La navigation principale est le système central de navigation au sein d’un site. Elle permet d’orienter l’usager à travers les rubriques principales et secondaires du site.


- [Présentation](../index.md)
- [Démo](../demo/index.md)
- Design
- [Code](../code/index.md)
- [Accessibilité](../accessibility/index.md)



![Anatomie de la navigation principale](../_asset/anatomy/anatomy-1.png)












### Variations

**Liens directs**


- Utiliser les liens directs vers des pages destination pour les sites ou les rubriques qui n’ont pas ou peu de second niveau d’arborescence, en les combinant par exemple avec un [menu latéral](../../../../sidemenu/_part/doc/index.md).

**Menu déroulant**


- Utiliser les menus déroulant dans le cadre d’une architecture de l’information peu profonde, pour afficher les niveaux secondaires d’une rubrique.
- Proposer un maximum de 8 liens au sein d’un menu déroulant.

**Mega menu**


- Utiliser le mega menu lorsqu’une arborescence est profonde. Il s’agit d’un menu de navigation plus complexe qui donne accès à plusieurs niveaux de profondeur.
- Proposer un maximum de 8 liens au sein de chaque sous catégorie.

**Responsive**

En version mobile, la navigation principale est accessible depuis le pictogramme “burger”. Le clic sur le pictogramme déclenche l’affichage d’un overlay présentant les éléments de la navigation et les liens directs de l’en-tête, si présents.

Le système d’overlay permet l’affichage du contenu des différentes variations de menu, précédemment décrites.

### Tailles

La largeur de la navigation principale est de taille fixe et prend les 12 colonnes disponibles de la grille.

### États

**État au survol**

L’état au survol correspond au comportement constaté par l’usager lorsqu’il survole une entrée de la navigation principale.

**État au clic**

L’état au clic correspond au comportement constaté par l’usager après avoir cliqué sur une entrée de la navigation principale. Il existe 2 états au clic, selon la variation choisie :

- Lien direct

- Menu déroulant ou mega menu

### Personnalisation

La navigation principale n’est pas personnalisable.

Toutefois, certains éléments sont optionnels - voir [la structure du composant](#navigation-principale).



![](./assets/_asset/custom/do-1.png)

Conserver un fond de couleur blanc derrière les entrées de la navigation principale.



![](./assets/_asset/custom/dont-1.png)

Ne pas personnaliser la couleur des entrées de la navigation principale



![](./assets/_asset/custom/do-2.png)

Utiliser uniquement la couleur bleu pour les entrées de menu déroulant ou mega menu dans leur état cliqué.



![](./assets/_asset/custom/dont-2.png)

Ne pas personnaliser la couleur des entrées menu déroulant ou mega menu lorsqu’elles sont cliquées.



![](./assets/_asset/custom/do-3.png)

Conserver le fond de couleur blanc du mega menu.



![](./assets/_asset/custom/dont-3.png)

Ne pas personnaliser ou retirer la couleur de fond du mega menu.



![](./assets/_asset/custom/do-4.png)

Conserver les tailles, types et couleurs de typographie des différents libellés en l’état.



![](./assets/_asset/custom/dont-4.png)

Ne pas modifier les tailles, types et couleurs de typographie des différents libellés.


