# Onglet

> **Structuration de contenu avec des onglets**

## Navigation

- [Accessibilité](./accessibilite.md) - Guide d'accessibilité RGAA
- [Code](./code.md) - Documentation technique et API
- [Design](./design.md) - Spécifications design
- [Exemples](./examples/) - Exemples de code HTML

## Onglet

Le système d’onglets permet de structurer et de présenter plusieurs sections de contenu liées, en affichant une seule section à la fois dans un espace limité.


- Présentation
- [Démo](./demo/index.md)
- [Design](./design/index.md)
- [Code](./code/index.md)
- [Accessibilité](./accessibility/index.md)



### Quand utiliser ce composant ?

Utiliser le système d'onglets pour regrouper du contenu lié dans un espace limité ou diviser un contenu dense en sections accessibles individuellement, afin de faciliter la lecture pour l’usager.

> [!NOTE]
> Il est recommandé d’utiliser des onglets si vous avez moins de 5 sections. Si vous avez plus de 5 sections, utilisez plutôt des [accordéons](../../../accordion/_part/doc/index.md)<br>
> N’utilisez pas les onglets pour naviguer entre différentes pages, préférez un menu latéral ou un sommaire.

### Comment utiliser ce composant ?

- **Trier les onglets en fonction des besoins des usagers**, en plaçant le plus important en premier.
- **Séparer le contenu utilement, en sections clairement identifiées**. Dans le cas contraire, les onglets perdent de leur pertinence.
- **Adapter leur utilisation au contexte**. Les onglets ne doivent pas être utilisés si l’usager a besoin de lire le contenu de l’ensemble des sections.
- **Intégrer les onglets dans des pages de contenu de préférence courtes** afin qu’ils ne se perdent pas dans la masse d’information. L’usager doit pouvoir y revenir facilement si nécessaire.

### Règles éditoriales

- **Rédiger un titre d’onglet clair, explicite et concis**. L’utilisateur doit comprendre facilement le contenu proposé par chacun des onglets.
