---
name: configuration-management
description: Infrastructure configuration with Ansible, Chef, Puppet, and SaltStack for automated server management
sasmp_version: "1.3.0"
bonded_agent: 04-infrastructure-as-code
bond_type: PRIMARY_BOND
---

# Configuration Management Skill

## MANDATORY
- Ansible playbooks and roles
- Inventory management (static and dynamic)
- Idempotent configuration patterns
- Variable management and templating
- Common modules (package, service, file, user)

## OPTIONAL
- Chef cookbooks and recipes
- Puppet manifests and modules
- SaltStack states and pillars
- Configuration drift detection
- Secret management integration

## ADVANCED
- Custom Ansible modules
- Multi-environment orchestration
- Performance optimization for large fleets
- Integration with IaC tools
- Compliance as Code

## Assets
- See `assets/ansible-patterns.yaml` for playbook templates
