# Bash Best Practices

## Essential Settings
```bash
set -euo pipefail  # Exit on error, undefined vars, pipe failures
```

## Style Guide
- Use `[[ ]]` for tests (not `[ ]`)
- Quote variables: `"$var"`
- Use functions for reusability
- Add error handling

## Tools
- **ShellCheck**: Static analysis
- **shfmt**: Formatter
- **bats**: Testing framework
