# Statistical Test Selection Guide

## Test Selection Decision Tree

```
What type of data do you have?
│
├─► Categorical vs Categorical
│   ├─► 2x2 table → Chi-square or Fisher's exact
│   └─► Larger table → Chi-square test
│
├─► Continuous vs Categorical
│   ├─► 2 groups
│   │   ├─► Normal data → Independent t-test
│   │   └─► Non-normal → Mann-Whitney U
│   │
│   ├─► 2 groups (paired)
│   │   ├─► Normal data → Paired t-test
│   │   └─► Non-normal → Wilcoxon signed-rank
│   │
│   └─► 3+ groups
│       ├─► Normal data → One-way ANOVA
│       └─► Non-normal → Kruskal-Wallis
│
└─► Continuous vs Continuous
    ├─► Linear relationship
    │   ├─► Normal data → Pearson correlation
    │   └─► Non-normal → Spearman correlation
    │
    └─► Prediction → Regression analysis
```

## Quick Reference Table

| Scenario | Parametric Test | Non-parametric Alternative |
|----------|-----------------|---------------------------|
| 2 independent groups | Independent t-test | Mann-Whitney U |
| 2 paired groups | Paired t-test | Wilcoxon signed-rank |
| 3+ independent groups | One-way ANOVA | Kruskal-Wallis |
| 3+ paired groups | Repeated measures ANOVA | Friedman test |
| Correlation | Pearson | Spearman |
| Independence (categorical) | Chi-square | Fisher's exact |

## Assumptions Checklist

### For Parametric Tests (t-test, ANOVA)

```
□ Independence of observations
□ Normality (Shapiro-Wilk test p > 0.05)
□ Homogeneity of variance (Levene's test p > 0.05)
□ Continuous dependent variable
```

### For Chi-square Test

```
□ Independence of observations
□ Expected frequencies ≥ 5 in each cell
□ Mutually exclusive categories
□ Large enough sample (n > 20)
```

## Sample Size Guidelines

| Test Type | Minimum per Group | Recommended |
|-----------|-------------------|-------------|
| t-test | 12 | 30+ |
| ANOVA | 20 per group | 30+ per group |
| Chi-square | Expected freq ≥ 5 | n > 100 |
| Correlation | 30 | 50+ |
| Regression | 10-20 per predictor | 50+ per predictor |

## Effect Size Interpretation

### Cohen's d (t-tests)
| Value | Interpretation |
|-------|----------------|
| 0.2 | Small |
| 0.5 | Medium |
| 0.8 | Large |

### Eta-squared (ANOVA)
| Value | Interpretation |
|-------|----------------|
| 0.01 | Small |
| 0.06 | Medium |
| 0.14 | Large |

### Correlation (r)
| Value | Interpretation |
|-------|----------------|
| 0.1 | Small |
| 0.3 | Medium |
| 0.5 | Large |

## P-value Decision Guide

```
P-value Interpretation:
───────────────────────────────────────
p < 0.001  │  Strong evidence against H0
p < 0.01   │  Very strong evidence
p < 0.05   │  Moderate evidence (typical threshold)
p < 0.10   │  Weak evidence (suggestive)
p ≥ 0.10   │  Little to no evidence
───────────────────────────────────────
```

## Multiple Comparison Corrections

| Method | When to Use | How It Works |
|--------|-------------|--------------|
| Bonferroni | Few comparisons | α / n |
| Holm | Many comparisons | Step-down procedure |
| FDR (Benjamini-Hochberg) | Many comparisons | Controls false discovery rate |
| Tukey HSD | Post-hoc ANOVA | Pairwise comparisons |

## Common Mistakes to Avoid

1. **p-hacking**: Running multiple tests until finding significance
2. **Ignoring assumptions**: Running parametric tests on non-normal data
3. **Small samples**: Underpowered studies missing real effects
4. **Multiple comparisons**: Not adjusting for many tests
5. **Confusing statistical and practical significance**
6. **Correlation ≠ Causation**
