# Job Aid Creator Skill

A comprehensive skill for creating quick-reference job aids, checklists, decision trees, flowcharts, and visual reference materials that provide just-in-time performance support.

## Skill Overview

**Name:** job-aid-creator  
**Purpose:** Create visual, concise job aids for point-of-need performance support  
**When to Use:** When employees need quick reference materials, not full training or formal procedures

## Directory Structure

```
job-aid-creator/
├── SKILL.md                              # Main skill documentation
├── assets/                               # Templates for different job aid types
│   ├── checklist-template.md            # Sequential task checklists
│   ├── decision-tree-template.md        # Yes/no decision support tools
│   ├── process-flowchart-template.md    # Workflow visualizations
│   ├── quick-reference-card-template.md # Compact info lookup
│   ├── comparison-table-template.md     # Option evaluation tables
│   └── process-map-template.md          # Cross-functional swimlanes
├── examples/                             # Real-world examples
│   ├── leave-type-decision-tree.md      # Employee leave type selector
│   └── new-hire-checklist.md            # Week 1 onboarding checklist
└── references/                           # Supporting documentation
    └── visual-design-principles.md       # Layout and design best practices
```

## Job Aid Types Supported

1. **Checklists** - Sequential tasks that must be completed
2. **Decision Trees** - Help make the right choice between options
3. **Process Flowcharts** - Visualize complex workflows
4. **Quick Reference Cards** - Frequently needed info or shortcuts
5. **Comparison Tables** - Choose between similar options
6. **Process Maps** - Show handoffs between people/departments

## Key Differentiators

**vs. SOPs (Standard Operating Procedures):**
- Job aids are visual and condensed (1-2 pages)
- SOPs are formal and comprehensive (3-10 pages)
- Job aids for quick reference, SOPs for compliance

**vs. How-To Guides:**
- Job aids assume basic knowledge
- How-to guides teach from scratch with screenshots
- Job aids are scannable, guides are educational

## Quick Start

When creating a job aid:

1. **Identify the need** - What do users need quickly?
2. **Choose format** - Checklist, decision tree, flowchart, etc.
3. **Keep it visual** - Icons, colors, shapes, tables
4. **One page ideal** - Maximum two pages
5. **Test with users** - Can they find info in <30 seconds?

## Design Principles

✅ **Do:**
- Use white space generously
- Keep to 1-2 pages maximum
- Use clear headings and bold key terms
- Make it scannable (bullets, tables, visuals)
- Test in black & white

❌ **Don't:**
- Write paragraphs (use bullets/tables)
- Cram too much information
- Use tiny fonts (<11pt)
- Include background/training content
- Rely on color alone to convey meaning

## Common Use Cases

- **Decision support** - "Which leave type should I use?"
- **Task completion** - "New hire first week checklist"
- **Quick lookup** - "System keyboard shortcuts"
- **Process flow** - "Requisition approval workflow"
- **Comparison** - "Health plan options comparison"
- **Troubleshooting** - "Common errors and fixes"

## Example Scenarios

**"I need something employees can reference at their desk to quickly decide which leave type to use"**
→ Use decision-tree-template.md

**"I need a checklist for managers to ensure they complete all new hire tasks"**
→ Use checklist-template.md

**"I need a one-page reference for Oracle keyboard shortcuts"**
→ Use quick-reference-card-template.md

**"I need a visual showing how position requisitions flow through approvals"**
→ Use process-flowchart-template.md

## Version History

- **v1.0** (November 2025) - Initial skill creation with 6 templates, 2 examples, and design guide
