---
name: job-aid-creator
description: Create quick-reference job aids, checklists, flowcharts, decision trees, and visual reference materials for point-of-need performance support. Use when users need just-in-time guidance, one-page references, process flowcharts, decision tools, or quick lookup guides that employees can reference while performing tasks.
---

# Job Aid Creator

Create visual, concise job aids that provide just-in-time support for employees at their point of need.

## When to Use This Skill

Use this skill when users request:
- Quick reference guides or cheat sheets
- Process flowcharts or workflow diagrams
- Decision trees or decision support tools
- Checklists for task completion
- Comparison tables or reference cards
- Visual process maps
- One-page reference materials
- Desktop quick references
- Point-of-need performance support tools

## How Job Aids Differ from SOPs and How-To Guides

**Job Aids:**
- **Purpose:** Quick reference at point of need
- **Format:** Visual, condensed, scannable (often one page)
- **Use Case:** Employee already knows basics but needs reminder
- **Content:** Key steps, decision points, critical info only
- **Design:** Highly visual with flowcharts, tables, icons
- **Length:** Typically 1-2 pages maximum
- **Example:** "Quick Reference: Which Leave Type to Use"

**SOPs (Standard Operating Procedures):**
- **Purpose:** Standardize processes for compliance and consistency
- **Format:** Formal, detailed, comprehensive documentation
- **Use Case:** Authoritative source for how to perform regulated tasks
- **Content:** Complete procedures with roles, approvals, quality checks
- **Design:** Text-heavy with formal structure
- **Length:** 3-10 pages
- **Example:** "Standard Operating Procedure: Processing Background Checks"

**How-To Guides:**
- **Purpose:** Train users to learn new software/systems
- **Format:** Educational walkthrough with teaching context
- **Use Case:** First-time users learning a new system or process
- **Content:** Detailed steps with screenshots and explanations
- **Design:** Progressive disclosure with quick reference + detailed instructions
- **Length:** 5-20 pages
- **Example:** "Complete Guide: How to Create a Job Requisition in Oracle"

**When to Use What:**
- **Job Aid:** Employee needs to quickly verify which form to use
- **How-To Guide:** Employee is learning the system for the first time
- **SOP:** Process must meet compliance requirements with formal documentation

## Core Workflow

### 1. Understand the Need

Before creating a job aid, gather key information:

**Essential Questions:**
- What task or decision point needs support?
- What is the employee's current knowledge level?
- Where/when will this be used? (at desk, in field, on phone)
- What specific information do they need quickly?
- What are the most common questions or confusion points?
- Does a similar resource already exist?

**Determine Format:**
- Is this a sequence of steps? → Checklist or simple flowchart
- Is this a decision that needs to be made? → Decision tree
- Is this comparing options? → Comparison table
- Is this a complex process flow? → Process map/flowchart
- Is this quick lookup information? → Reference card

### 2. Choose the Appropriate Job Aid Type

Select the format that best supports the task:

**Checklist** (`assets/checklist-template.md`)
- **Use for:** Sequential tasks that must be completed in order
- **Best for:** Quality assurance, pre-flight checks, onboarding tasks
- **Format:** Numbered or bulleted list with checkboxes
- **Example:** "New Hire First Day Checklist"

**Decision Tree** (`assets/decision-tree-template.md`)
- **Use for:** Helping employees make the right choice between options
- **Best for:** Leave type selection, routing decisions, troubleshooting
- **Format:** Flowchart with yes/no branches leading to outcomes
- **Example:** "Which Leave Type Should I Use?"

**Process Flowchart** (`assets/process-flowchart-template.md`)
- **Use for:** Visualizing complex workflows with multiple paths
- **Best for:** Multi-step processes, approval workflows, system interactions
- **Format:** Shapes with decision points, actions, and flow arrows
- **Example:** "Position Request Approval Flow"

**Quick Reference Card** (`assets/quick-reference-card-template.md`)
- **Use for:** Frequently needed information or shortcuts
- **Best for:** System shortcuts, contact lists, code references
- **Format:** Compact table or list, often landscape orientation
- **Example:** "Oracle HCM Quick Keyboard Shortcuts"

**Comparison Table** (`assets/comparison-table-template.md`)
- **Use for:** Helping users choose between similar options
- **Best for:** Product selection, policy comparisons, feature differences
- **Format:** Multi-column table with criteria rows
- **Example:** "Health Plan Options Comparison"

**Process Map** (`assets/process-map-template.md`)
- **Use for:** Showing handoffs between people/departments
- **Best for:** Cross-functional workflows, swimlane diagrams
- **Format:** Horizontal flow with lanes for each role/department
- **Example:** "Recruitment Process: Hiring Manager to HR"

### 3. Design Principles for Effective Job Aids

**Visual Hierarchy:**
- Use size, color, and weight to show importance
- Most critical info should be most prominent
- Group related information together
- Use white space generously

**Scannable Layout:**
- Keep it to one page if possible (max 2 pages)
- Use clear headings and subheadings
- Bullet points over paragraphs
- Bold key terms and actions
- Use icons, colors, or symbols consistently

**Action-Oriented Language:**
- Start with verbs (Check, Select, Choose, Verify)
- Be direct and concise
- Eliminate unnecessary words
- Use imperatives: "Select your leave type" not "You should select..."

**Visual Elements:**
- Icons for quick visual recognition
- Color coding for categories or severity
- Arrows to show flow or sequence
- Borders or boxes to group related items
- Highlighting for critical information

### 4. Content Guidelines

**What to Include:**
- ✅ Only essential information needed to perform the task
- ✅ Critical decision criteria
- ✅ Common mistakes to avoid (brief warnings)
- ✅ Contact information if escalation needed
- ✅ Document version and date

**What to Exclude:**
- ❌ Detailed explanations or rationale
- ❌ Background information or history
- ❌ Training content or "how to learn"
- ❌ Edge cases or rare scenarios
- ❌ Information that rarely changes

**Write Concisely:**
- One thought per line when possible
- Use fragments instead of complete sentences when clear
- Target 3-7 words per bullet point
- Replace sentences with tables when appropriate
- Use abbreviations if universally understood

### 5. Formatting Standards

**For Print/PDF Job Aids:**
- Standard paper size (8.5" x 11" or landscape 11" x 8.5")
- Minimum 11pt font for body text
- High contrast (dark text on light background)
- Leave margins for hole-punching if desk reference
- Consider lamination for durability

**For Digital Job Aids:**
- Mobile-friendly if accessed on phones
- Linkable sections for digital navigation
- Downloadable PDF option
- Searchable text (not images of text)
- Accessible format (screen reader compatible)

**For Flowcharts and Diagrams:**
- Use standard flowchart symbols:
  - Rectangle = Process/Action
  - Diamond = Decision Point
  - Oval = Start/End
  - Arrow = Flow Direction
- Consistent shape sizes
- Clear, readable text inside shapes
- Logical top-to-bottom or left-to-right flow
- Minimal crossing lines

### 6. Quality Checklist

A high-quality job aid should:
- ✅ Fit on one page (or two pages maximum)
- ✅ Be scannable in under 30 seconds
- ✅ Include only essential information
- ✅ Use visual elements effectively (icons, colors, shapes)
- ✅ Have clear hierarchy and organization
- ✅ Use action-oriented language
- ✅ Be usable without additional explanation
- ✅ Include version/date information
- ✅ Be tested with actual users
- ✅ Work in the intended context (desk, mobile, field)

## Common Job Aid Types and Use Cases

### Checklists
**Best for:**
- Pre-event preparation
- Quality assurance reviews
- Compliance verification
- Onboarding task lists

**Key Features:**
- Sequential order if necessary
- Checkboxes for completion tracking
- Brief description for each item
- Clear completion criteria

### Decision Trees
**Best for:**
- Choosing between multiple options
- Troubleshooting problems
- Routing decisions
- Policy application

**Key Features:**
- Clear yes/no questions
- Logical branching
- Definitive outcomes
- No circular loops

### Process Flowcharts
**Best for:**
- Visualizing complex workflows
- Showing approval paths
- System integration flows
- Exception handling

**Key Features:**
- Standard flowchart symbols
- Clear decision points
- Alternative paths shown
- Start and end points marked

### Quick Reference Cards
**Best for:**
- System shortcuts
- Code references
- Contact information
- Frequently used formulas

**Key Features:**
- Highly compressed information
- Table or list format
- Alphabetical or logical grouping
- Easy to print/laminate

### Comparison Tables
**Best for:**
- Product/service selection
- Policy comparisons
- Feature differences
- Option evaluation

**Key Features:**
- Clear column headers
- Consistent criteria rows
- Visual highlights for key differences
- Easy to scan horizontally

## Examples of Good vs. Poor Job Aid Content

❌ **Poor:** "Employees should carefully review all available leave options in the employee handbook and consult with their supervisor to determine which type of leave is most appropriate for their specific situation, taking into account factors such as..."

✅ **Good:** 
```
Which Leave Type?
• Medical appointment → Sick Leave
• Vacation → Vacation Leave  
• Death in family → Bereavement Leave
• Jury duty → Civic Leave
Questions? HR@creighton.edu | x2000
```

---

❌ **Poor:** "The approval process involves multiple steps and requires coordination between various departments. First, the employee submits the request, then it goes to the supervisor..."

✅ **Good:**
```
[Flowchart showing]:
Employee Submits → Manager Approves? 
  → YES → HR Reviews → End
  → NO → Return to Employee → End
```

---

❌ **Poor:** Lengthy paragraph explaining every scenario and exception

✅ **Good:** 
```
✅ DO: Submit 2 weeks in advance
⚠️ AVOID: Last-minute requests
❌ DON'T: Submit if already approved elsewhere
```

## Testing and Iteration

**User Testing:**
- Give to 2-3 target users
- Watch them use it in context
- Note where they hesitate or struggle
- Ask: "What's missing?" and "What's confusing?"

**Refine Based On:**
- Time to complete task using the job aid
- Number of questions asked while using it
- Error rate or mistakes made
- User satisfaction and confidence

**Update Triggers:**
- Process changes
- System updates
- Frequent user questions
- Error patterns identified

## Version Control

Always include on the job aid:
- **Version number** (e.g., "v2.1")
- **Last updated date** (e.g., "Updated: Nov 2025")
- **Contact for questions** (email or extension)
- **Document owner/department**

When updating:
- Increment version (major change = 1.0 → 2.0, minor = 1.0 → 1.1)
- Note changes in file name or revision log
- Redistribute to users who have old version
- Archive previous versions

## Output Format

Create job aids as:
- **Markdown** (.md) files for digital use and easy conversion
- **PDF** for printing and distribution
- **Image files** (.png, .jpg) for inclusion in presentations
- **Editable formats** (for future updates by others)

Always provide:
1. A markdown source file
2. Notes on how to implement visual elements (if flowcharts/diagrams)
3. Recommendations for printing (size, orientation, color vs. B&W)

## Deliverable

Create a complete, ready-to-use job aid that includes:
- All essential content with no extraneous information
- Clear visual hierarchy and formatting
- Appropriate format for the use case (checklist, flowchart, table, etc.)
- Version and date information
- Contact information for questions
- Testing recommendations

The job aid should be immediately usable by the target audience with no additional work required (except adding visuals if specified).

## Additional Resources

See these files for templates and examples:
- `assets/checklist-template.md` - Sequential task lists
- `assets/decision-tree-template.md` - Yes/no decision support
- `assets/process-flowchart-template.md` - Workflow visualization
- `assets/quick-reference-card-template.md` - Compact info lookup
- `assets/comparison-table-template.md` - Option evaluation
- `assets/process-map-template.md` - Cross-functional workflows
- `references/visual-design-principles.md` - Layout and design guidance
- `examples/leave-type-decision-tree.md` - Real-world example
