# [Process Name] - Process Map

**Purpose:** [What this process accomplishes]  
**Scope:** [Start point] to [End point]  
**Frequency:** [How often this occurs]

---

## Swimlane Process Map

**Read from left to right. Each row represents a different role/department.**

```
┌─────────────────────────────────────────────────────────────────────────────┐
│ [ROLE/DEPT 1]                                                               │
├─────────────────────────────────────────────────────────────────────────────┤
│                                                                             │
│  [Step 1]  ──→  [Step 2]  ──→  [Decision]  ──→ YES ──→  [Step 3]          │
│                                      │                                      │
│                                      NO                                     │
│                                      ↓                                      │
│                                 [Alt Step]                                  │
│                                      │                                      │
└──────────────────────────────────────┼──────────────────────────────────────┘
                                       ↓
┌──────────────────────────────────────┼──────────────────────────────────────┐
│ [ROLE/DEPT 2]                        ↓                                      │
├──────────────────────────────────────────────────────────────────────────────┤
│                                                                             │
│                                  [Step 4]  ──→  [Step 5]                   │
│                                                     │                       │
│                                                     ↓                       │
└─────────────────────────────────────────────────────┼────────────────────────┘
                                                      ↓
┌─────────────────────────────────────────────────────┼────────────────────────┐
│ [ROLE/DEPT 3]                                       ↓                       │
├──────────────────────────────────────────────────────────────────────────────┤
│                                                                             │
│                                                 [Step 6]  ──→  [END]       │
│                                                                             │
└──────────────────────────────────────────────────────────────────────────────┘
```

---

## Detailed Step Descriptions

### [Role/Dept 1] Activities

**Step 1: [Step Name]**
- **Action:** [What happens]
- **Duration:** [Typical time]
- **Key Inputs:** [What's needed]

**Step 2: [Step Name]**
- **Action:** [What happens]
- **Duration:** [Typical time]
- **Key Inputs:** [What's needed]

**Decision Point: [Decision Name]**
- **Criteria for YES:** [When to proceed]
- **Criteria for NO:** [When to take alternate path]

**Step 3: [Step Name]**
- **Action:** [What happens]
- **Duration:** [Typical time]
- **Key Outputs:** [What's produced]

### [Role/Dept 2] Activities

**Step 4: [Step Name]**
- **Action:** [What happens]
- **Duration:** [Typical time]
- **Key Inputs:** [What's needed from Role 1]

**Step 5: [Step Name]**
- **Action:** [What happens]
- **Duration:** [Typical time]
- **Key Outputs:** [What's passed to next role]

### [Role/Dept 3] Activities

**Step 6: [Step Name]**
- **Action:** [What happens]
- **Duration:** [Typical time]
- **Key Outputs:** [Final deliverables]

---

## Handoff Points

**Critical handoffs between roles:**

| **From** | **To** | **What's Transferred** | **Timing** |
|----------|--------|------------------------|------------|
| [Role 1] | [Role 2] | [Deliverable/Info] | [When] |
| [Role 2] | [Role 3] | [Deliverable/Info] | [When] |

---

## Total Process Time

| **Phase** | **Duration** | **Owner** |
|-----------|--------------|-----------|
| [Role 1] activities | [X hours/days] | [Role 1] |
| [Role 2] activities | [X hours/days] | [Role 2] |
| [Role 3] activities | [X hours/days] | [Role 3] |
| **TOTAL CYCLE TIME** | **[X hours/days]** | |

---

## Key Responsibilities by Role

| **Role/Department** | **Primary Responsibilities** |
|---------------------|------------------------------|
| [Role 1] | • [Responsibility 1]<br>• [Responsibility 2] |
| [Role 2] | • [Responsibility 1]<br>• [Responsibility 2] |
| [Role 3] | • [Responsibility 1]<br>• [Responsibility 2] |

---

## Escalation Path

**If issues arise:**

| **Issue Type** | **Escalate To** | **Contact** |
|----------------|-----------------|-------------|
| [Issue 1] | [Role/Name] | [Contact info] |
| [Issue 2] | [Role/Name] | [Contact info] |
| [Issue 3] | [Role/Name] | [Contact info] |

---

## Success Metrics

This process is successful when:
- ✅ [Metric 1: e.g., Cycle time < X days]
- ✅ [Metric 2: e.g., Error rate < X%]
- ✅ [Metric 3: e.g., Customer satisfaction > X]

---

## Common Bottlenecks and Solutions

| **Bottleneck** | **Impact** | **Solution** |
|----------------|------------|--------------|
| [Issue] at [Step] | [Effect on process] | [How to resolve] |
| [Issue] at [Step] | [Effect on process] | [How to resolve] |

---

**Process Owner:** [Name/Department] | [contact]  
**Version:** [v1.0] | **Last Updated:** [Month Year] | **Next Review:** [Month Year]
