# Leave Type Decision Tree

**Purpose:** Help employees and managers select the correct leave type for time off requests  
**Target Audience:** All Creighton University employees and supervisors

---

## Quick Decision Guide

**START HERE: Why do you need time off?**

```
┌──────────────────────────────────────────┐
│  Is this for your own illness/medical?   │
└────────────────┬─────────────────────────┘
                 │
        ┌────────┴────────┐
        │                 │
       YES               NO
        │                 │
        ▼                 ▼
┌─────────────────┐  ┌──────────────────────────┐
│ Medical for you?│  │ Is this for family care? │
└────────┬────────┘  └──────────┬───────────────┘
         │                      │
    ┌────┴────┐            ┌────┴────┐
    │         │            │         │
   YES       NO           YES       NO
    │         │            │         │
    ▼         ▼            ▼         ▼
  ┌─┐       ┌─┐          ┌─┐       ┌─────────────────┐
  │A│       │B│          │C│       │ Is this vacation│
  └─┘       └─┘          └─┘       │ or personal?    │
                                    └────────┬────────┘
                                             │
                                        ┌────┴────┐
                                        │         │
                                       YES       NO
                                        │         │
                                        ▼         ▼
                                      ┌─┐    ┌────────────┐
                                      │D│    │ Other      │
                                      └─┘    │ Reasons?   │
                                             └──────┬─────┘
                                                    │
                                              See Options
                                              Below (E-I)
```

---

## Outcomes Explained

### A: **Sick Leave**

**Use when:** You are ill, injured, or need medical/dental care for yourself

**Examples:**
- Doctor appointments
- Flu or cold
- Surgery and recovery
- Mental health days
- Preventive care visits

**Key info:** Does NOT require advance notice for emergencies. For planned medical appointments, notify supervisor as soon as possible.

---

### B: **Personal Illness/Injury (Non-Sick-Leave Eligible)**

**Use when:** You're not eligible for sick leave but need medical time off

**Who this applies to:**
- Student employees
- Temporary employees
- Some part-time positions

**Note:** Check with HR about your leave eligibility

---

### C: **Family Care Leave**

**Use when:** Caring for an ill family member or attending their medical appointments

**Eligible family members:**
- Spouse
- Children
- Parents
- Other dependents

**Examples:**
- Taking child to doctor
- Caring for sick spouse
- Parent's surgery/recovery

**Key info:** May require documentation depending on duration. Coordinate with HR for extended absences.

---

### D: **Vacation Leave**

**Use when:** Taking planned time off for rest, travel, or personal reasons

**Examples:**
- Holidays and trips
- Extended weekends
- Personal time off
- Relaxation

**Key info:** 
- Requires advance request (typically 2+ weeks for extended time)
- Subject to supervisor approval based on coverage needs
- Cannot be taken during first 90 days (new employees)

---

## Other Leave Types (E-I)

### E: **Bereavement Leave**

**Use when:** Death of a family member

**Duration:** Typically 3-5 days depending on relationship  
**Contact:** HR immediately to discuss eligibility

---

### F: **Jury Duty**

**Use when:** Summoned for jury service

**Key info:** Provide court documentation to supervisor  
**Note:** You may be required to return to work if dismissed early

---

### G: **Military Leave**

**Use when:** Called to active duty or training

**Key info:** Provide military orders to HR as soon as received

---

### H: **FMLA (Family & Medical Leave Act)**

**Use when:** 
- Serious health condition (yours or family member's)
- Childbirth or adoption
- Caring for a family member with serious illness

**Duration:** Up to 12 weeks unpaid (may run concurrent with paid leave)  
**Contact:** HR Benefits team to start FMLA paperwork

---

### I: **Unpaid Leave**

**Use when:** You've exhausted paid leave but need additional time

**Key info:** Requires HR and supervisor approval. Benefits may be affected.

---

## Still Not Sure?

**If you're uncertain after using this decision tree:**

- ✉️ **Email HR:** hr@creighton.edu
- ☎️ **Call HR:** (402) 280-2709
- 🌐 **HR Portal:** [my.creighton.edu/hr](https://my.creighton.edu/hr)
- 📍 **Visit:** Old Gym, 2nd Floor

---

## Common Scenarios

| **Scenario** | **Use This Leave Type** |
|--------------|-------------------------|
| You have a cold and can't come in | **Sick Leave (A)** |
| Your child is sick and you need to stay home | **Family Care Leave (C)** |
| You're taking a week off to visit family | **Vacation Leave (D)** |
| Your grandmother passed away | **Bereavement Leave (E)** |
| You have a dental cleaning | **Sick Leave (A)** |
| You're taking your parent to a medical appointment | **Family Care Leave (C)** |
| You need a mental health day | **Sick Leave (A)** |
| You were selected for jury duty | **Jury Duty (F)** |
| You're having surgery with 6-week recovery | **FMLA (H)** - Contact HR |

---

## Important Reminders

⚠️ **For emergencies:** Notify your supervisor as soon as possible  
⚠️ **For planned time:** Request at least 2 weeks in advance when possible  
⚠️ **Documentation:** May be required for medical leaves over 3 consecutive days  
⚠️ **FMLA:** For serious medical conditions, contact HR immediately to protect your rights

---

## How to Submit Your Leave Request

1. Log in to **myHR** at my.creighton.edu/hr
2. Navigate to **Time Off Requests**
3. Select the appropriate **Leave Type** (use this guide!)
4. Enter **dates and details**
5. Submit to supervisor for approval

💡 **Pro tip:** Take a screenshot of this decision tree for quick reference!

---

**Version:** v1.2 | **Last Updated:** November 2025 | **Owner:** Human Resources  
**Questions?** Contact HR at hr@creighton.edu or (402) 280-2709
