# New Hire First Week Checklist

**Purpose:** Ensure all critical onboarding tasks are completed during new employee's first week  
**Target Audience:** HR Team, Hiring Managers, New Employees  
**Estimated Time:** Week 1 (various tasks throughout)

---

## Prerequisites

Before Day 1, ensure:
- [ ] Offer letter signed and returned
- [ ] Background check completed
- [ ] I-9 documents received and verified
- [ ] Workstation and equipment ordered
- [ ] Email account created
- [ ] Building/system access requested

---

## Day 1: Welcome and Orientation

### Morning (HR)
- [ ] **Welcome new employee** at reception (9:00 AM)
- [ ] **Complete I-9 verification** in HR office
- [ ] **Distribute employee handbook** and review key policies
- [ ] **Enroll in benefits** (if eligible) - schedule time with Benefits team
- [ ] **Issue BluejayCard** (campus ID)
- [ ] **Provide parking pass/transit info** (if applicable)

### Afternoon (Hiring Manager)
- [ ] **Tour of workspace** and facilities (restrooms, break rooms, exits)
- [ ] **Introduce to immediate team members** (schedule 15 min with each)
- [ ] **Provide login credentials** for key systems
- [ ] **Explain work schedule** and attendance expectations
- [ ] **Assign first-week buddy** for questions

---

## Day 2-3: Systems and Training

### Technology Setup
- [ ] **Log in to myCreighton portal** and verify access
- [ ] **Set up email** (Outlook/Gmail) and signature
- [ ] **Test Oracle HCM access** (view paycheck, time off balance)
- [ ] **Complete IT security training** (required within 48 hours)
- [ ] **Set up Microsoft Teams** and join department channels
- [ ] **Test printer/copier access** with assigned code

### Mandatory Training
- [ ] **Complete sexual harassment prevention training** (online)
- [ ] **Complete FERPA training** (if applicable to role)
- [ ] **Review emergency procedures** (evacuation routes, shelter locations)
- [ ] **Complete department-specific training** (assigned by manager)

### Administrative Tasks
- [ ] **Submit W-4 and state tax forms** (if not completed during offer)
- [ ] **Enroll in direct deposit** in myHR portal
- [ ] **Designate emergency contacts** in myHR
- [ ] **Sign up for TimeClock/timesheet system** (if applicable)

---

## Day 4-5: Role-Specific Setup

### Job-Specific Orientation
- [ ] **Review position description** and expectations with manager
- [ ] **Identify 30-60-90 day goals** with manager
- [ ] **Schedule recurring 1-on-1 meetings** with supervisor
- [ ] **Request access to role-specific systems** (if not already granted)
- [ ] **Join relevant committees/working groups** (if applicable)

### Relationship Building
- [ ] **Schedule coffee chats** with 3-5 key collaborators
- [ ] **Introduce yourself** to department via email/Teams
- [ ] **Attend team meeting** (if scheduled this week)
- [ ] **Add yourself to department org chart** (if maintained)

### Learning and Development
- [ ] **Review department shared drive/documentation** repository
- [ ] **Bookmark key resources** (forms, templates, SOPs)
- [ ] **Identify training needs** and discuss with manager
- [ ] **Join relevant Slack/Teams channels** for your role

---

## End of Week 1: Wrap-Up

### Manager Check-In (Friday)
- [ ] **Conduct 30-minute check-in** with new employee
- [ ] **Answer questions** about first week experience
- [ ] **Clarify priorities** for Week 2
- [ ] **Address any concerns** or issues that arose

### HR Check-In
- [ ] **Send Week 1 survey** to new employee (anonymous feedback)
- [ ] **Verify all access granted** and systems working
- [ ] **Confirm enrollment in benefits** (if applicable)
- [ ] **Schedule 30-day check-in** with HR

### New Employee Self-Check
- [ ] **Can you access all systems** needed for your job?
- [ ] **Do you know who to ask** when you have questions?
- [ ] **Do you understand your role** and initial responsibilities?
- [ ] **Have you identified key resources** (people, docs, tools)?
- [ ] **Do you feel welcomed** by your team?

---

## ⚠️ Common Mistakes to Avoid

- ❌ **Skipping I-9 completion** - Must be done within 3 days of hire
- ❌ **Not enrolling in benefits on time** - Limited enrollment window (30 days)
- ❌ **Delaying IT security training** - Required within 48 hours per policy
- ❌ **Not introducing new hire to team** - Leads to feeling isolated
- ❌ **Information overload Day 1** - Space out training over the week

---

## ✅ Completion Criteria

Week 1 onboarding is successful when:
- All mandatory compliance training completed
- Access to critical systems verified and working
- Benefits enrollment completed (if eligible)
- New employee can articulate their role and initial goals
- Manager and HR have conducted check-ins

---

## Escalation

**If issues arise during onboarding:**

| **Issue Type** | **Contact** |
|----------------|-------------|
| IT/System access problems | IT Help Desk @ x2050 or helpdesk@creighton.edu |
| Benefits questions | HR Benefits @ x2709 or hrbenefits@creighton.edu |
| Payroll/tax issues | HR Payroll @ x2715 or payroll@creighton.edu |
| General onboarding | HR Generalist @ x2709 or hr@creighton.edu |
| Role/job questions | Direct Supervisor |

---

## Resources

🔗 **New Employee Portal:** my.creighton.edu/new-employees  
🔗 **Employee Handbook:** my.creighton.edu/hr/handbook  
🔗 **Training Resources:** my.creighton.edu/learning  
🔗 **Campus Map:** creighton.edu/map

---

**Questions?** Contact HR at hr@creighton.edu | x2709  
**Version:** v2.0 | **Last Updated:** November 2025
