# Compliance & Inclusive Language Guidelines

Ensure all job postings comply with employment law and use inclusive, non-discriminatory language.

## Legal Compliance Checklist

### Equal Employment Opportunity (EEO)

**Standard EEO Statement (if applicable):**
> "[Organization Name] is an Equal Opportunity Employer and does not discriminate on the basis of race, color, religion, sex, sexual orientation, gender identity, national origin, protected veteran status, disability, or any other legally protected status."

**When to include:**
- Required for federal contractors and organizations with 15+ employees
- Best practice for all external job postings
- Typically placed at end of posting

**Jesuit/Catholic institutions may include:**
> "[Organization Name] is an Equal Opportunity Employer and does not discriminate in any employment practice on the basis of race, color, religion, sex, sexual orientation, gender identity, national origin, protected veteran status, disability, or any other legally protected status, except where permitted by law in the case of a religious organization."

### Americans with Disabilities Act (ADA) Compliance

**Physical Requirements:**
- ❌ Avoid: "Must be able to lift 50 pounds"
- ✅ Better: "Ability to lift up to 50 pounds occasionally with or without reasonable accommodation"

**Essential Functions:**
- Clearly distinguish essential vs. marginal functions
- Use "with or without reasonable accommodation" language
- Focus on outcomes, not methods

**Accommodation Statement:**
> "Reasonable accommodations may be made to enable individuals with disabilities to perform the essential functions."

### Age Discrimination

**Prohibited terms:**
- ❌ "Recent graduate"
- ❌ "Digital native"
- ❌ "High energy"
- ❌ "Young and dynamic team"
- ❌ Specific years of experience that aren't job-related

**Compliant alternatives:**
- ✅ "Entry-level professional"
- ✅ "Proficient with digital tools"
- ✅ "Fast-paced environment"
- ✅ "Collaborative team"
- ✅ "Minimum X years of experience in [specific skill]"

## Inclusive Language

### Gender-Neutral Language

**Pronouns:**
- ❌ "He will manage" or "She will oversee"
- ✅ "The candidate will manage" or use "they"
- ✅ Use second person: "You will oversee"

**Job titles:**
- ❌ Salesman, Waitress, Stewardess
- ✅ Sales Representative, Server, Flight Attendant
- ❌ Cleaning lady, Repairman
- ✅ Custodian, Repair Technician

**Generic references:**
- ❌ "Man the front desk"
- ✅ "Staff the front desk"
- ❌ "Manpower needed"
- ✅ "Staffing needed" or "Personnel needed"

### Ability-Inclusive Language

**Avoid ableist metaphors:**
- ❌ "Stand-up meetings"
- ✅ "Brief daily check-ins"
- ❌ "See the project through"
- ✅ "Complete the project"

**Physical requirements:**
- Be specific about actual needs
- Don't assume abilities
- Include accommodation language

### Socioeconomic Inclusivity

**Avoid requirements that aren't essential:**
- ❌ "Must have reliable transportation" (unless truly required)
- ✅ "Ability to travel between campus locations"
- ❌ "Professional wardrobe required"
- ✅ "Business casual dress code" (if necessary)

### Cultural & Linguistic Inclusivity

**Avoid cultural bias:**
- ❌ "Native English speaker"
- ✅ "Strong written and verbal communication skills in English"
- ❌ "Culturally fits our team"
- ✅ "Aligns with our values of [specific values]"

**Educational credentials:**
- ❌ "Degree from accredited US institution required"
- ✅ "Bachelor's degree or equivalent"
- Include "or equivalent experience" when possible

### Family Status

**Prohibited references:**
- ❌ Marital status
- ❌ Parental status
- ❌ Family obligations
- ❌ Childcare arrangements

**Schedule requirements:**
- ✅ Be clear about actual needs: "This position requires evening availability"
- ❌ Don't ask about: "Must be available for last-minute schedule changes"

## Red Flag Terms to Avoid

### Potentially Discriminatory Language

| Avoid | Why | Use Instead |
|-------|-----|-------------|
| "Recent graduate" | Age discrimination | "Entry-level professional" |
| "Digital native" | Age discrimination | "Proficient with current technology" |
| "Culture fit" | Can mask bias | "Values alignment with [specific values]" |
| "Aggressive" | Gender-coded | "Proactive," "results-driven" |
| "Rockstar," "Ninja," "Guru" | Unprofessional, age-coded | Specific skill descriptions |
| "Must be comfortable in fast-paced startup environment" | Age/ability coded | "Comfortable with ambiguity and changing priorities" |
| "Work hard, play hard" | Excludes people with family obligations | Describe actual culture |

### Gender-Coded Language to Avoid

**Masculine-coded terms that may discourage women:**
- Aggressive, Ambitious, Analytical, Assert, Autonomous
- Competitive, Confident, Decisive, Determined, Dominant
- Independent, Leader, Logic, Objective, Opinion

**Feminine-coded terms that may discourage men:**
- Agree, Affectionate, Caring, Collaborative, Committed
- Compassionate, Cooperative, Dependable, Interpersonal
- Loyal, Nurture, Responsible, Sensitive, Support

**Neutral alternatives:**
- "Results-oriented" instead of "aggressive"
- "Collaborative" paired with "independent"
- "Strong analytical and interpersonal skills"
- Mix traditionally masculine and feminine terms

## Religious Organization Exemptions

For Jesuit/Catholic organizations, certain religious preferences ARE legally permissible:

**Permissible:**
- ✅ "Candidate must be a Roman Catholic in good standing" (for ministry positions)
- ✅ "Knowledge of Ignatian Spirituality required"
- ✅ "Commitment to Catholic/Jesuit mission and values"

**Best practices:**
- Only include when truly essential for the role
- Be specific about why (e.g., "This position leads retreats based on the Spiritual Exercises")
- Include in requirements, not as preferences

## Quality Check Questions

Before finalizing, ask:

- [ ] Does this language unnecessarily exclude qualified candidates?
- [ ] Are physical requirements stated with accommodation language?
- [ ] Is the language gender-neutral throughout?
- [ ] Are we using "must have" only for truly essential qualifications?
- [ ] Have we avoided age-coded terms?
- [ ] Does the posting focus on skills and outcomes rather than demographic characteristics?
- [ ] Is the EEO statement included (if required)?
- [ ] Have we reviewed for unconscious bias?

## Resources & References

**EEOC Guidance:**
- [EEOC Pre-Employment Inquiries](https://www.eeoc.gov/prohibited-employment-policiespractices)
- [ADA and Employment](https://www.ada.gov/topics/employment/)

**Best Practices:**
- Use tools like [Gender Decoder](http://gender-decoder.katmatfield.com/) to check for coded language
- Review postings with diverse team members
- Update templates annually based on evolving best practices

**Additional Considerations for Religious Organizations:**
- [Ministerial Exception](https://www.eeoc.gov/laws/guidance/section-12-religious-discrimination#h_9546146701031549974670926) - EEOC guidance
- Title VII exemptions for religious organizations

## Common Fixes

### Before → After Examples

**Example 1: Age bias**
- ❌ "Looking for recent grad with 2-3 years experience and high energy to join our young team"
- ✅ "Seeking early-career professional with 2-3 years experience in [specific area] to join our collaborative team"

**Example 2: Gender-coded**
- ❌ "Dominant leader who can aggressively pursue sales targets"
- ✅ "Results-driven professional who proactively pursues sales targets and builds strong client relationships"

**Example 3: Ability assumptions**
- ❌ "Must be able to stand for 8-hour shifts and lift 50 pounds"
- ✅ "This position requires the ability to stand for extended periods and occasionally lift up to 50 pounds, with or without reasonable accommodation"

**Example 4: Educational bias**
- ❌ "MBA from top-tier US university required"
- ✅ "Master's degree in Business Administration or equivalent required"

**Example 5: Cultural fit**
- ❌ "Looking for someone who fits our fun, laid-back culture"
- ✅ "We value collaboration, continuous learning, and work-life balance. Ideal candidates will align with our commitment to [specific organizational values]"
