# Job Description Content Extraction Guidelines

When reformatting job descriptions, systematically extract and categorize information from the source document.

## Core Information to Extract

### Position Details
- **Position Title**: Official job title
- **Department/Unit**: Organizational unit or department
- **Location**: City, State (or specific campus if applicable)
- **Employment Type**: Full-time, Part-time, Temporary, etc.
- **Reports To**: Supervisor or reporting relationship
- **Grade/FLSA Status**: If provided (usually in formal JDs)
- **Job Code**: If provided

### Position Summary/Purpose
Look for sections labeled:
- "Position Summary"
- "Overview"
- "Purpose"
- "Job Summary"

Extract: The high-level purpose, scope, and strategic importance of the role.

### Responsibilities/Duties
Look for sections labeled:
- "Essential Functions"
- "Responsibilities"
- "Key Responsibilities"
- "Duties"
- "What You'll Do"

Extract and organize by:
- Primary duties (usually with percentage of time if formal JD)
- Secondary duties
- Supervisory responsibilities
- Special projects or ad-hoc duties

### Qualifications
Look for sections labeled:
- "Education & Experience"
- "Qualifications"
- "Requirements"
- "Knowledge, Skills, and Abilities"
- "Competencies"

Separate into:
- **Required**: Must-have education, experience, skills, certifications
- **Preferred**: Nice-to-have qualifications
- **Physical Requirements**: If applicable
- **Licenses/Certifications**: Specific credentials needed

### Additional Details
Extract when present:
- Work schedule specifics
- Travel requirements
- Salary range
- Special conditions (evenings, weekends, on-call)
- Reporting relationships
- Supervisory scope (number of direct reports)
- Budget responsibilities

## Handling Different Input Formats

### Formal HR Job Descriptions
These typically include:
- Structured sections with labels
- Percentage of time allocations
- Detailed physical requirements
- FLSA classification
- Formal language

**Action**: Extract all structured data; simplify formal language for public posting.

### Informal/Draft Job Descriptions
These may include:
- Loose organization
- Conversational tone
- Missing standard sections
- Bullet points without context

**Action**: Infer standard categories; organize scattered information; formalize language.

### Job Postings from Other Organizations
These may include:
- Different organizational terminology
- Varied formatting conventions
- Different emphasis areas

**Action**: Translate to target organization's conventions; maintain core content; adjust tone.

### Image/Screenshot Formats
Information may be:
- Mixed with formatting elements
- Partial or truncated
- Combined with other postings

**Action**: Focus on extracting complete sentences; note any ambiguities; ask for clarification if critical information is unclear.

## Content Prioritization

### High Priority (Always Include)
- Position title
- Department/location
- Core responsibilities (top 5-7)
- Required qualifications
- Reporting relationship
- Application instructions

### Medium Priority (Include When Available)
- Preferred qualifications
- Detailed responsibilities
- Work schedule specifics
- Organizational context
- Salary information

### Low Priority (Include Space Permitting)
- Physical requirements (unless critical)
- Detailed FLSA information
- Job codes (usually internal)
- Granular percentage allocations

## Quality Checks

Before completing reformatting:
- [ ] All key responsibilities captured
- [ ] Required vs. preferred qualifications clearly separated
- [ ] Reporting relationship identified
- [ ] Location specified
- [ ] Application process clear
- [ ] Tone matches target template
- [ ] No critical information omitted
- [ ] No placeholder text like "[INSERT]" remains
