# Compatibility Between Organizational Systems

A comprehensive overview of six major open-source modular storage systems: **Gridfinity**, **Underware**, **OpenGrid**, **French Cleat**, **Neogrid**, and **Deskware**. Each section summarizes the system's concept, specifications, and compatibility with others.

______________________________________________________________________

## Gridfinity

Read ./gridfinity-reference.md for full details.

### Compatibility

| System           | Compatible?     | Notes                                                          |
| ---------------- | --------------- | -------------------------------------------------------------- |
| **OpenGrid**     | ✅ Partial      | 3 OpenGrid units = 2 Gridfinity units (84 mm shared dimension) |
| **Underware**    | ⚙️ Indirect     | Can mount holders for Gridfinity bins under desks              |
| **French Cleat** | ✅ With adapter | Bins can attach using cleat-mounted backplates                 |
| **Neogrid**      | ⚙️ Theoretical  | Aligns via 42 mm multiples in drawer inserts                   |
| **Deskware**     | ✅ Native       | Top plates can have Gridfinity baseplate recesses (42mm grid)  |

______________________________________________________________________

## Underware 2.0

Read ./underware-reference.md for full details.

### Compatibility

| System           | Compatible? | Notes                                                        |
| ---------------- | ----------- | ------------------------------------------------------------ |
| **Gridfinity**   | ⚙️ Limited  | Gridfinity bins can be stored near or above cable runs       |
| **OpenGrid**     | ✅ Full     | Native integration (snaps directly into grid)                |
| **French Cleat** | ⚙️ Partial  | Can hang channels or power strips with short cleats          |
| **Neogrid**      | ⚙️ Optional | Not directly integrated but can coexist in workspace drawers |
| **Deskware**     | ✅ Full     | Cable channels route through or under Deskware risers        |

______________________________________________________________________

## OpenGrid

Read ./opengrid-reference.md for full details.

### Compatibility

| System           | Compatible?     | Notes                                                   |
| ---------------- | --------------- | ------------------------------------------------------- |
| **Gridfinity**   | ✅ Proportional | 3 × 28 mm = 2 × 42 mm = 84 mm (shared scale)            |
| **Underware**    | ✅ Full         | Direct snap-in integration                              |
| **French Cleat** | ⚙️ Indirect     | Can be wall-mounted with cleat-backed boards            |
| **Neogrid**      | ✅ Supported    | Alignment and modular integration for drawers           |
| **Deskware**     | ✅ Native       | Top plates can have OpenGrid board recesses (28mm grid) |

______________________________________________________________________

## French Cleat

Read ./french-cleat-reference.md for full details.

### Compatibility

| System         | Compatible?       | Notes                                              |
| -------------- | ----------------- | -------------------------------------------------- |
| **Gridfinity** | ✅ Adapter-based  | Bins attach using cleat backplates                 |
| **Underware**  | ⚙️ Partial        | Can support under-desk mounts on short cleats      |
| **OpenGrid**   | ✅ Adapter boards | Tiles or accessories can mount with cleat adapters |
| **Neogrid**    | ⚙️ Minimal        | Possible through hybrid shelving but not native    |
| **Deskware**   | ⚙️ Indirect       | Wall-mounted cleats work alongside desk risers     |

______________________________________________________________________

## Neogrid

Read ./neogrid-reference.md for full details.

### Compatibility

| System           | Compatible?       | Notes                                                          |
| ---------------- | ----------------- | -------------------------------------------------------------- |
| **Gridfinity**   | ✅ Full alignment | Uses 42 mm multiples for spacing                               |
| **Underware**    | ⚙️ None           | Different domain (drawers vs. cables)                          |
| **OpenGrid**     | ✅ Supported      | Neogrid 2.0 adds OpenGrid base compatibility                   |
| **French Cleat** | ⚙️ Indirect       | Can hang trays using cleat-mounted adapters                    |
| **Deskware**     | ⚙️ Indirect       | Drawer organization below desk, not direct physical connection |

______________________________________________________________________

## Deskware

Read ./deskware-reference.md for full details.

### Compatibility

| System           | Compatible? | Notes                                                            |
| ---------------- | ----------- | ---------------------------------------------------------------- |
| **Gridfinity**   | ✅ Native   | Top plates can include Gridfinity baseplate recesses (42mm grid) |
| **OpenGrid**     | ✅ Native   | Top plates can include OpenGrid snap points (28mm grid)          |
| **Underware**    | ✅ Full     | Cable channels route through or under Deskware risers            |
| **French Cleat** | ⚙️ Indirect | Wall-mounted cleats behind desk work alongside Deskware          |
| **Neogrid**      | ⚙️ Indirect | Drawer organization below desk, not direct physical connection   |

### Native Integrations

- **Gridfinity**: Top plates can include Gridfinity baseplate recesses (42mm grid)
- **OpenGrid**: Top plates can include OpenGrid snap points (28mm grid, Lite or Full thickness)

### Complementary Integrations

- **Underware**: Cable channels route through or under Deskware risers
- **French Cleat**: Wall-mounted cleats behind desk work alongside Deskware

### Indirect Integrations

- **Neogrid**: Drawer organization below desk, not direct physical connection
