# French Cleat Reference

## What Is a French Cleat?

A **French cleat** is a simple yet powerful wall-mounting system used for hanging shelves, cabinets, tools, and modular storage accessories. It consists of two interlocking strips cut at a **45° angle** — one fixed to the wall, and the other attached to the object being mounted. When the angled faces meet, gravity locks the object in place while allowing it to be lifted off easily.

The design originated in traditional woodworking and cabinetry but has been widely adopted for workshops, garages, and 3D-printed modular systems. It’s prized for **strength, modularity, and reconfigurability** — a single wall of cleats can support dozens of interchangeable mounts.

______________________________________________________________________

## Core Concept

### Structure

A French cleat uses:

- **Wall cleat** – mounted securely to the wall with the bevel facing up and out.
- **Accessory cleat** – attached to the back of the hanging object, with the bevel facing down and in.
- When mated, the angled faces wedge together under load, creating a strong mechanical lock.

### Key Dimensions

| Parameter                | Typical Value                         | Notes                                        |
| ------------------------ | ------------------------------------- | -------------------------------------------- |
| **Cleat width**          | 75–100 mm (3–4 in)                    | Wider for heavier loads                      |
| **Cleat thickness**      | 12–18 mm (½–¾ in)                     | Match your board material                    |
| **Angle**                | 45° standard                          | Steeper angles (e.g. 30°) for easier removal |
| **Spacing between rows** | 100–150 mm                            | Determines modular grid height               |
| **Material**             | Plywood, hardwood, or printed plastic | Plywood is most common                       |

______________________________________________________________________

## How It Works

1. The **wall cleat** is screwed into studs or anchors along a level line.
2. The **accessory cleat** is attached to the back of your shelf, bin, or tool holder.
3. To mount, simply lower the accessory cleat onto the wall cleat until the beveled faces seat.
4. The angled joint converts downward force into inward pressure, locking the mount securely.

Because the load transfers into the wall rather than relying on fastener shear, French cleats can support **very heavy weights** — easily 100 kg+ when properly built.

______________________________________________________________________

## Building a French Cleat Wall

### Materials

- **Plywood (18 mm / ¾ in)** – ideal balance of strength and workability.
- **Screws** – wood screws or construction screws (≥ 5 mm / #10).
- **Stud finder & level** – for accurate alignment.
- **Table saw or circular saw with adjustable bevel** – to cut the 45° angle.

### Steps

1. **Cut cleats:** Rip a plywood sheet into 75–100 mm wide strips at a 45° bevel.
2. **Sand edges:** Lightly sand to remove sharp corners.
3. **Mark wall studs:** Use a level and stud finder to lay out mounting lines.
4. **Attach wall cleats:** Screw into studs every 40–60 cm along length.
5. **Add spacers:** Maintain even vertical spacing (100–150 mm).
6. **Mount accessories:** Attach matching cleats to bins, cabinets, or tool racks.

For full walls, start from the bottom and work up. This ensures the lower cleats support those above during installation.

______________________________________________________________________

## Using French Cleats

Once installed, the wall becomes a **universal mounting interface**. Accessories can be rearranged without tools — simply lift and move.

Common attachments include:

- Tool holders and bins
- Cabinets and shelves
- Power tool charging stations
- 3D-printed organizers
- Lighting mounts
- Art and décor panels

Because cleats align automatically, accessories sit perfectly straight every time.

______________________________________________________________________

## Load Capacity and Safety

| Material           | Cleat Length | Approx. Load | Notes                        |
| ------------------ | ------------ | ------------ | ---------------------------- |
| 3/4 in plywood     | 600 mm       | 45–70 kg     | Per stud connection          |
| 3/4 in hardwood    | 600 mm       | 80–100 kg    | Excellent for heavy cabinets |
| PETG print         | 100 mm       | 5–10 kg      | Suitable for small bins      |
| Aluminum extrusion | 500 mm       | 100 kg+      | Industrial setups            |

### Safety Tips

- Always mount into studs or solid masonry.
- Use screws, not nails.
- Don’t rely on drywall anchors alone for heavy items.
- Test new designs with progressive loading before full deployment.

______________________________________________________________________

## Modular Design Patterns

### 1. Continuous Cleat Wall

Full-width cleats every 10 cm. Allows infinite rearrangement of accessories.

### 2. Sectioned Cleats

Short, independent cleats (e.g., 300 mm). Easier to replace.

### 3. Hidden Cleats

Recessed behind cabinetry — invisible from the front but retain adjustability.

### 4. Vertical Cleats

Occasionally used for special mounts; less common but can support side-mounted accessories.

______________________________________________________________________

## Advanced Tips

- **Stack alignment:** Use a 10 mm spacer jig to ensure even row spacing.
- **Angle adjustment:** Shallower cleats (30°–35°) ease lifting heavy accessories.
- **Integrated power:** Route power strips behind cleats for charging stations.
- **Finish:** Paint or varnish to improve durability and visibility of row spacing.
- **Printed inserts:** Add logos, color coding, or labels to cleat ends for organization.

______________________________________________________________________

## Common Mistakes

| Issue                        | Cause                 | Solution                              |
| ---------------------------- | --------------------- | ------------------------------------- |
| Cleats not seating           | Wall not level        | Re-check alignment with level         |
| Rattling or play             | Excessive tolerance   | Reduce bevel gap or add retention lip |
| Sagging mounts               | Screws not in studs   | Ensure stud attachment                |
| Layer separation (3D prints) | Incorrect orientation | Print with bevel side up              |
| Wall damage                  | Overloaded cleat      | Distribute load across more cleats    |

______________________________________________________________________

## Maintenance & Reconfiguration

- Periodically check screw tightness.
- Keep cleats dust-free to maintain smooth fit.
- When rearranging, lift vertically to disengage — never pull outward.
- Repaint or sand lightly as needed to maintain smooth contact faces.
- Replace damaged sections easily without disturbing adjacent cleats.

______________________________________________________________________

## Design Principles

- **Simplicity:** Two boards, one angle, infinite flexibility.
- **Strength through geometry:** Converts load into compression rather than tension.
- **Reconfigurability:** Infinite rearrangement of accessories.
- **Compatibility:** Works with wood, metal, or 3D-printed components.
- **Aesthetics:** Clean, professional, “shop-ready” or “living-room-compatible.”

______________________________________________________________________

## Official & Community Resources

- **Inspiration & guides:**
  - [https://makerworld.com/](https://makerworld.com/) (search “French cleat”)
- **Reference designs:**
  - Woodsmith Shop Episode 180
  - DIY Builds, April Wilkerson, and Hands on Katie for modular implementations
- **Parametric generators:**
  - Custom cleat generator on MakerWorld
  - OpenSCAD libraries for cleat profiles

______________________________________________________________________

## Common Use Cases

- Workshop tool walls
- 3D printer accessory storage
- Garage cabinetry
- Modular kitchen storage
- Office and craft organization
- Portable panels for event displays

______________________________________________________________________

## Quick Setup Reference

1. **Decide cleat layout**: Full-wall or sectional.
2. **Cut or print cleats**: 45° angle, matching pairs.
3. **Mark and mount wall cleats**: Level and secure into studs.
4. **Attach accessory cleats**: Back of tools, bins, or panels.
5. **Test fit and adjust**: Verify alignment and stability.
6. **Expand modularly**: Add rows or accessories over time.

## Use with Frenchfinity

Can also be used to hold Frenchfinity-generated tool holders and organizers, combining the flexibility of French cleats with the customizability of 3D printing. Read ./frenchfinity-reference.md to see how to use Frenchfinity with French cleats.
