# Frenchfinity Reference: Tactical Quick Guide

## What is Frenchfinity?

Frenchfinity is a **modular, 3D-printable sub-system** designed to standardize tool holders for the **French Cleat** wall organization framework. It addresses the lack of standardization in traditional French cleat holders by offering a fully **customizable, less-waste** approach for makers and workshops. See <https://frenchfinity.xyz/> for full documentation and resources.

______________________________________________________________________

## Core Specifications

| Feature           | Detail                                                                                                            |
| :---------------- | :---------------------------------------------------------------------------------------------------------------- |
| **Base System**   | French Cleat (for heavy wall mounting)                                                                            |
| **Design Core**   | Parametric modeling in **Fusion 360** and an **OpenSCAD customizer** (Frenchfinity 2.0) for perfect customization |
| **Mounting**      | Compatible with standard wooden French cleat walls. Also supports screw-in mounting for non-cleat users.          |
| **Modularity**    | **Less-waste** design through replaceable modules                                                                 |
| **Compatibility** | Seamless integration with **Gridfinity** using a dedicated adapter                                                |
| **Materials**     | Supports **plastic-only** printing or **hybrid** setups combining plastic with wood to save filament              |

______________________________________________________________________

## Key Components

- **Wall Anchor**: The modular, 3D-printed French cleat anchor that is fully adjustable to fit any wall width.
- **Tool Holder**: Custom-generated or pre-designed module that slides and locks into the Wall Anchor.
- **French Plate**: A component used to provide added stability and keep holders securely seated on the cleat wall.
- **Gridfinity Adapter**: Essential component for adding Gridfinity bins and plates to the Frenchfinity system.

______________________________________________________________________

## Common Tool Holders & Official Resources

Frenchfinity provides a variety of pre-designed holders, many of which offer fully customizable parameters. Always check the official resource page for the latest files and customizers.

| Tool Holder            | Purpose                                                                       | MakerWorld Link                                                                                                                                   | Printables Link                                                                                       |
| :--------------------- | :---------------------------------------------------------------------------- | :------------------------------------------------------------------------------------------------------------------------------------------------ | :---------------------------------------------------------------------------------------------------- |
| **Gridfinity Adapter** | Integrates Frenchfinity wall holders with the **42mm Gridfinity** base system | [Link](https://www.google.com/search?q=https://makerworld.com/en/models/861509-gridfinity-frenchfinity-adapter-french-cleat)                      | N/A (Discontinued on Printables)                                                                      |
| **T-Handle Holder**    | Perfectly tailored for storing T-handled tools for accessibility              | [Link](https://www.google.com/search?q=https://makerworld.com/en/models/861509-gridfinity-frenchfinity-adapter-french-cleat) (URL may be general) | [Link](https://www.printables.com/model/1101699-frenchfinity-french-cleat-guide) (URL may be general) |
| **Can Holder**         | Secures spray cans, paint cans, or similar items                              | [Link](https://www.google.com/search?q=https://makerworld.com/en/models/861509-gridfinity-frenchfinity-adapter-french-cleat) (URL may be general) | [Link](https://www.printables.com/model/1101699-frenchfinity-french-cleat-guide) (URL may be general) |
| **Allen Key Holder**   | Provides compact and organized storage for sets of Allen keys                 | [Link](https://www.google.com/search?q=https://makerworld.com/en/models/861509-gridfinity-frenchfinity-adapter-french-cleat) (URL may be general) | [Link](https://www.printables.com/model/1101699-frenchfinity-french-cleat-guide) (URL may be general) |
| **Tablet Holder**      | Securely holds a tablet for referencing manuals or tutorials                  | [Link](https://www.google.com/search?q=https://makerworld.com/en/models/861509-gridfinity-frenchfinity-adapter-french-cleat) (URL may be general) | [Link](https://www.printables.com/model/1101699-frenchfinity-french-cleat-guide) (URL may be general) |
| **GluBot Holder**      | Keeps glue bottles upright and within reach for hassle-free use               | [Link](https://www.google.com/search?q=https://makerworld.com/en/models/861509-gridfinity-frenchfinity-adapter-french-cleat) (URL may be general) | [Link](https://www.printables.com/model/1101699-frenchfinity-french-cleat-guide) (URL may be general) |
| **Wall Anchor**        | The modular, adjustable French cleat anchor piece                             | [Link](https://www.google.com/search?q=https://makerworld.com/en/models/861509-gridfinity-frenchfinity-adapter-french-cleat) (URL may be general) | [Link](https://www.printables.com/model/1101699-frenchfinity-french-cleat-guide) (URL may be general) |

______________________________________________________________________

## Print Settings and Tips

- **Material**: Recommended use of **PLA+** or **PETG** for strength.
- **Infill**: **10% Gyroid** is a suggested setting.
- **Orientation**: Print with the T-Slot (cleat tongue) **vertical** to minimize the need for supports.
- **Filament Use**: Frenchfinity is perfect for using up **filament leftovers** by printing small, single tool holders.
