# OpenGrid Reference

## What is OpenGrid?

OpenGrid is an open-source, modular wall and desk mounting framework for 3D printing. Created by David D and released under CC-BY license, it emphasizes "living room compatibility" with clean aesthetics suitable for any room, not just workshops.

## Core Specifications

### Grid System

- **Base unit**: 28mm x 28mm spacing
- **Board types**: Full Board (6.8mm thick) and Lite Board (4mm thick)
- **Material savings**: -70% filament for Lite Board, -30% for Full Board vs similar systems
- **Front-side access**: All operations performed from front (no wall access needed after mounting)

### Board Dimensions

- **Grid spacing**: 28mm x 28mm per square
- **Full Board**: 6.8mm thickness - heavy-duty applications
- **Lite Board**: 4mm thickness - light applications, integrated screw holes
- **Connection**: Plastic pegs in edge holes for alignment between boards

### Print Settings

- **Layer height**: 0.2mm
- **Infill**: 15-20%
- **Walls**: 3 walls recommended
- **Material**: PLA or PETG
- **Nozzle**: 0.4mm recommended

## Key Components

### Boards

- **Purpose**: Base mounting surface with grid pattern
- **Sizes**: Flexible from 4x4 to 10x10+ grids (limited by printer bed)
- **Mounting**: Lite boards have integrated screw holes; Full boards use mounting snaps
- **Connection**: Edge connectors align multiple boards together

### Snaps

- **Purpose**: Building blocks for attaching boards to surfaces and accessories to boards
- **Types**: Basic snaps, directional snaps, lock snaps, mounting snaps
- **Function**: Insert into grid holes to hold accessories or mount to walls
- **Multiconnect compatible**: Universal interface for wide accessory ecosystem

### Mounting Options

- **Lite Board**: Direct screw-through integrated holes
- **Full Board**: Mounting snaps with optional decorative covers
- **Front-side only**: Add mounting points after installation
- **Hardware**: Standard metric screws (M4-M6 common, #6 in US)

## Compatibility & Integration

### Gridfinity Compatibility

- **Relationship**: 3 OpenGrid units = 2 Gridfinity units (both equal 84mm)
- **Math**: 3 x 28mm = 2 x 42mm = 84mm
- **Usage**: Gridfinity accessories work with OpenGrid shelves (may need minor modifications)

### Other Compatible Systems

- **Multiconnect**: Default interface for accessories
- **Underware 2.0**: First-class cable management support
- **HSW**: Compatible with system
- **Multiboard**: Compatible with system
- **GOEWS**: Compatible with system
- **Metric screws**: Standard integration

## Design Principles

- Living room compatible aesthetics
- Front-side access only (no back access needed)
- Material efficiency (less filament than alternatives)
- Open framework for community extension
- Robust core parts to reduce decision fatigue
- CC-BY open license (free to use, modify, share with attribution)

## Official Resources

**Main Documentation:**

- Official site: <https://www.opengrid.world/>
- Quickstart guide: <https://www.opengrid.world/guides/quickstart/>
- Board guide: <https://www.opengrid.world/guides/board/>

**Downloads & Generators:**

- Printables: <https://www.printables.com/model/1214361-opengrid-walldesk-mounting-framework-and-ecosystem>
- MakerWorld: <https://makerworld.com/en/models/1179191-opengrid-wall-desk-mounting-framework-ecosystem>
- Tile Generator (MakerWorld): <https://makerworld.com/en/models/1304337-opengrid-tile-generator>
- Tile Generator (PerplexingLabs): <https://gridfinity.perplexinglabs.com/pr/opengrid/0/0>

**Specialty Versions:**

- M6 screw version (Printables): <https://www.printables.com/model/1219888-opengrid-m6-screw-board-version>
- M6 screw version (MakerWorld): <https://makerworld.com/en/models/1184183-opengrid-m6-screw-board-version>

**Related Projects:**

- Multiconnect system: By David D (universal mounting interface)
- Underware for OpenGrid: Cable management integration

## Common Use Cases

- Tool wall organization
- Under-desk cable routing
- 3D printer accessory mounting
- Modular workbench systems
- Custom connector experiments
- Desktop organization

## Setup Quick Reference

1. **Choose board type**: Full (heavy duty) or Lite (light applications)
2. **Determine size**: Print largest tiles that fit your printer bed
3. **Print boards**: 0.2mm layers, 15-20% infill, 3 walls
4. **Connect boards**: Use edge connectors for alignment
5. **Mount to surface**: Lite = direct screw; Full = mounting snaps
6. **Add snaps**: Insert into grid holes as needed
7. **Attach accessories**: Multiconnect or custom snaps

## Troubleshooting

- **Connectors too tight**: Check tolerances, sand lightly, or print at 99.5% scale
- **Board flexing**: Add more mounting points or switch to Full Board
- **Snaps not holding**: Verify correct snap type for application
- **Surface finish issues**: Screw hole side may have rougher finish - consider orientation when stacking

## Measuring Your Prints

- Board external dimensions = N x 28mm (where N = grid units)
- Full Board thickness = 6.8mm
- Lite Board thickness = 4mm
- Each grid square = 28mm x 28mm

______________________________________________________________________

*Last updated: October 2025*
*License: CC-BY*
*Creator: David D*
