# Underware 2.0 Reference

## What is Underware 2.0?

Underware 2.0 is an open-source, modular cable management system designed by Hands on Katie. It provides click-and-slide cable channels, item holders, and hooks for managing under-desk cables, power supplies, and peripherals. Released under CC-BY-NC-SA license, it's fully customizable with thousands of variations through the openGrid-compatible parametric generator.

## Core Concept

**Parametric cable management** - Underware 2.0 uses:

- **3D-printed cable channels** (customizable width, height, length)
- **Direct openGrid integration** (channels snap directly into 28mm grid)
- **Item holders** (for power supplies, USB hubs, keyboards, etc.)
- **Hooks and accessories** (for cable routing and organization)

## Core Specifications

### Channel System

- **Channel types**: I-channels, L-channels, T-channels, X-channels, Y-channels, diagonal, mitred, curved
- **Customization**: Width, height, length, radius (for curves), corner style
- **Cable cutouts**: Optional openings for routing cables
- **Multi-color support**: Labels and accent colors

### Mounting Compatibility

- **openGrid**: Channels click directly into 28mm grid
- **Direct mount**: Magnets, adhesive strips, wood screws for non-grid surfaces
- **Note**: Previously compatible with Multiboard, but openGrid is now the standard

### Channel Dimensions

- **Width**: Customizable to cable bundle size
- **Height**: Customizable to cable bundle thickness
- **Length**: Customizable to span between mounting points
- **Wall thickness**: Automatic based on mounting surface

## Key Components

### Cable Channels

- **I-Channel**: Straight runs (most common)
- **L-Channel**: 90Â° corners
- **T-Channel**: Three-way intersections (now with mitred corners)
- **X-Channel**: Four-way intersections
- **Curved Channel**: Smooth radius turns (customizable diameter)
- **Y-Channel**: Branching routes
- **Diagonal Channel**: Angled transitions
- **Mitred Channel**: Clean angle joints
- **Height Change Channel**: Smooth transitions between different heights

### Mounting Options

**For openGrid:**

- Channels snap directly into board (no additional connectors needed)
- Multiconnect snaps for item holders and heavy items
- Grip snaps for extra holding strength

**Alternative Mounting:**

- **Magnets**: Superglued into back holes (magnetic surfaces)
- **Adhesive strips**: Poster strips for curved surfaces (table legs)
- **Wood screws**: Direct screw mount

### Item Holders

- **Purpose**: Mount power supplies, USB hubs, mini PCs, keyboards, etc.
- **Generator**: BlackjackDuck's custom item holder with dimension/cutout options
- **Clamshell style**: Two-sided holders that enclose items while allowing ventilation
- **Grid calculation**: Automatic for openGrid

### Hooks & Accessories

- **Double-sided hooks**: Multiconnect mount
- **Multi-groove hooks**: Multiconnect mount
- **Single-sided hooks**: Multiconnect mount
- **Cable spool hooks**: For managing excess cable length
- **Channel base snap**: Provides floor for cable routing, zip-tie attachment points
- **Grip channel snap**: Increases holding strength when channels have heavy cables

## Print Settings

- **Layer height**: 0.2mm
- **Walls**: 3 walls recommended
- **Infill**: 15-20%
- **Material**: PLA or PETG
- **Supports**: Generally not needed (curved table mount exception)

## Design Principles

- Open-source and extensible
- Click-and-slide system for easy reconfiguration
- Infinite customization via parametric generators
- Native openGrid integration
- Clean aesthetics ("living room compatible")
- Iterative installation (print as you go)

## Official Resources

**Main Documentation:**

- Underware 2.0 page: <https://handsonkatie.com/underware-2-0-the-made-to-measure-collection/>
- openGrid integration guide: <https://www.opengrid.world/guides/quickstart/underware/>
- User documentation: <https://coda.io/@andylevesque/underware/underware-2-0-user-documentation-1>

**Downloads & Generators:**

- Underware for openGrid (MakerWorld): <https://makerworld.com/en/models/1329404-underware-for-opengrid-customizer-beta>
- Underware 2.0 (MakerWorld): <https://makerworld.com/en/models/783010-underware-2-0-infinite-cable-management>
- Custom Item Holder Generator: <https://makerworld.com/en/models/646872-custom-item-holder-multiconnect-multipoint-goews>

**Related Systems:**

- openGrid: <https://www.opengrid.world/>
- Multiconnect by David D: <https://www.printables.com/model/716558-multiconnect-generic-connector-for-your-board>

**Contributors:**

- Hands on Katie (original designer)
- BlackjackDuck (parametric generators, item holders)
- David D (Multiconnect, openGrid integration)
- Pedro (openGrid customizer)
- Community via GitHub: <https://github.com/AndyLevesque/QuackWorks/>

## Common Use Cases

- Under-desk cable management
- Wall-mounted cable routing
- Power supply and USB hub mounting
- Keyboard tray cable management
- Standing desk cable organization
- 3D printer station cable management
- Home office/entertainment center organization

## Setup Quick Reference

1. **Install openGrid boards**: Mount full-thickness openGrid boards under desk
2. **Print test channels**: Generate a few I-channels using the openGrid customizer
3. **Snap in channels**: Channels click directly into openGrid (no connectors needed)
4. **Route cables**: Work iteratively, adding channels as needed
5. **Add accessories**: Use Multiconnect snaps for item holders and heavy components

## Customization

### Using the Generators

- **Channel customizer**: Adjust width, height, length, mounting type, cable cutouts
- **Item holder**: Input device dimensions, select cutout locations, choose mounting
- **Options**: Add labels, change colors, adjust corner radius, modify wall thickness

### Key Parameters

- **Width/Height**: Match to cable bundle size (leave some room)
- **Length**: Distance between mounting points
- **Additional strength**: Toggle for heavier cable loads
- **Cable cutouts**: For entry/exit points along channel

## Troubleshooting

- **Channels too tight**: Increase width/height parameters slightly
- **Channels falling off**: Use grip channel snaps for extra holding strength
- **Heavy items sagging**: Switch to Multiconnect snaps instead of direct channel mounting
- **Curved surface mounting**: Use adhesive poster strips with curved mount option

## Workflow Best Practices

1. **Start with openGrid**: Install openGrid boards under desk first
2. **Map main routes**: Identify where major cable runs will go
3. **Print core channels**: Start with I-channels for main routes
4. **Install iteratively**: Don't plan everything upfront - print, install, assess, repeat
5. **Add intersections**: Use T, L, X channels as needed for branches
6. **Mount accessories**: Use item holders for power supplies and devices last
7. **Refine**: Add hooks, adjust channels, fill gaps as you discover needs

## Compatibility Notes

- Works best with openGrid full-thickness boards (better grip than lite)
- Can mix with Neogrid (both by Hands on Katie)
- Multiconnect provides universal mounting interface across systems
- LED channel use: Print in transparent filament for light diffusion
- **Historical note**: Previously compatible with Multiboard 25mm grid system

______________________________________________________________________

*Last updated: October 2025*
*License: CC-BY-NC-SA*
*Creator: Hands on Katie (Katie)*
*Contributors: BlackjackDuck, David D, DMG, Pedro, and community*
