# Contributing to Claude Skill Optimizer

Thank you for your interest in contributing! This document provides guidelines for contributors.

## 🚀 Quick Start

```bash
# Fork and clone
git clone https://github.com/YOUR_USERNAME/claude-skill-optimizer.git
cd claude-skill-optimizer

# Setup development environment
python -m venv venv
source venv/bin/activate
pip install -e ".[dev]"

# Run tests
pytest tests/

# Run linting
ruff check src/
```

## 📋 Development Workflow

1. **Create a branch**: `git checkout -b feature/your-feature`
2. **Make changes**: Follow coding standards below
3. **Test**: Ensure all tests pass
4. **Commit**: Use conventional commits
5. **Push**: `git push origin feature/your-feature`
6. **PR**: Open a Pull Request

## 💻 Coding Standards

- Use type hints
- Follow PEP 8
- Document public functions with docstrings
- Write tests for new features

```python
def calculate_score(traces: list[ExecutionTrace]) -> float:
    """
    Calculate aggregate score from execution traces.
    
    Args:
        traces: List of execution traces to evaluate
        
    Returns:
        Aggregate score between 0.0 and 1.0
    """
    ...
```

## 🧪 Testing

```bash
# All tests
pytest tests/

# With coverage
pytest tests/ --cov=src

# Specific test
pytest tests/unit/test_evaluators.py -v
```

## 📝 Commit Messages

Use conventional commits:

```
feat(evaluators): add brand compliance evaluator
fix(executor): handle timeout gracefully
docs(readme): add installation instructions
test(generators): add edge case tests
```

## 🎯 Areas of Interest

- New evaluators (visual, accessibility, localization)
- Skill-specific adapters
- Better test generation
- Documentation and tutorials
- CI/CD improvements

## ❓ Questions?

- Open a Discussion
- Check existing Issues
- Read the Documentation

---

Thank you for contributing! 🎉
