# Getting Started

This guide walks you through setting up and running your first skill optimization.

## Prerequisites

- Python 3.9 or higher
- Claude Code CLI (for real execution)
- A Claude skill to optimize

## Installation

### From Source

```bash
git clone https://github.com/yourusername/claude-skill-optimizer.git
cd claude-skill-optimizer
pip install -e .
```

### From PyPI (future)

```bash
pip install claude-skill-optimizer
```

## Quick Start

### 1. Choose a Skill to Optimize

The optimizer works with any Claude skill. Common locations:

| Environment | Path |
|-------------|------|
| Claude Code | `~/.claude/skills/{name}/` |
| Project | `./.claude/skills/{name}/` |
| Claude.ai | `/mnt/skills/public/{name}/` |

### 2. Initialize Optimization

```bash
skill-optimizer init \
    --skill-path ~/.claude/skills/pptx \
    --output-dir ./pptx-optimization
```

This creates:
- `config.yaml` - Optimization settings
- `test_cases.yaml` - Template for test cases

### 3. Define Test Cases

Edit `test_cases.yaml` with tasks that exercise the skill:

```yaml
test_cases:
  - id: basic_001
    description: "Create simple presentation"
    prompt: "Create a 3-slide presentation about AI"
    expected_outputs:
      - type: file
        pattern: "*.pptx"
    quality_criteria:
      - "Contains 3 slides"
      - "Title slide present"
    complexity: simple
```

### 4. Run Optimization

```bash
skill-optimizer optimize \
    --config ./pptx-optimization/config.yaml \
    --max-iterations 10
```

### 5. Review Results

```bash
# View report
cat ./pptx-optimization/results/report.md

# Compare changes
diff ~/.claude/skills/pptx/SKILL.md \
     ./pptx-optimization/results/optimized_skill/SKILL.md
```

### 6. Apply Optimized Skill

```bash
cp ./pptx-optimization/results/optimized_skill/SKILL.md \
   ~/.claude/skills/pptx/SKILL.md
```

## Using Mock Mode

For testing without Claude Code:

```bash
skill-optimizer optimize \
    --config config.yaml \
    --mock
```

## Next Steps

- [Configuration Guide](configuration.md)
- [Writing Test Cases](test-cases.md)
- [Custom Evaluators](custom-evaluators.md)
- [PPTX Examples](../examples/pptx-optimization/)
